<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarPublish StructType
 * @subpackage Structs
 */
class CalendarPublish extends AbstractStructBase
{
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enabled;
    /**
     * The range
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $range;
    /**
     * The relative
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RangeDays
     */
    public $relative;
    /**
     * The includePrivate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includePrivate;
    /**
     * Constructor method for CalendarPublish
     * @uses CalendarPublish::setEnabled()
     * @uses CalendarPublish::setRange()
     * @uses CalendarPublish::setRelative()
     * @uses CalendarPublish::setIncludePrivate()
     * @param bool $enabled
     * @param string $range
     * @param \StructType\RangeDays $relative
     * @param bool $includePrivate
     */
    public function __construct($enabled = null, $range = null, \StructType\RangeDays $relative = null, $includePrivate = null)
    {
        $this
            ->setEnabled($enabled)
            ->setRange($range)
            ->setRelative($relative)
            ->setIncludePrivate($includePrivate);
    }
    /**
     * Get enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param bool $enabled
     * @return \StructType\CalendarPublish
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get range value
     * @return string|null
     */
    public function getRange()
    {
        return $this->range;
    }
    /**
     * Set range value
     * @uses \EnumType\CalendarPublishRange::valueIsValid()
     * @uses \EnumType\CalendarPublishRange::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $range
     * @return \StructType\CalendarPublish
     */
    public function setRange($range = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarPublishRange::valueIsValid($range)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $range, implode(', ', \EnumType\CalendarPublishRange::getValidValues())), __LINE__);
        }
        $this->range = $range;
        return $this;
    }
    /**
     * Get relative value
     * @return \StructType\RangeDays|null
     */
    public function getRelative()
    {
        return $this->relative;
    }
    /**
     * Set relative value
     * @param \StructType\RangeDays $relative
     * @return \StructType\CalendarPublish
     */
    public function setRelative(\StructType\RangeDays $relative = null)
    {
        $this->relative = $relative;
        return $this;
    }
    /**
     * Get includePrivate value
     * @return bool|null
     */
    public function getIncludePrivate()
    {
        return $this->includePrivate;
    }
    /**
     * Set includePrivate value
     * @param bool $includePrivate
     * @return \StructType\CalendarPublish
     */
    public function setIncludePrivate($includePrivate = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePrivate) && !is_bool($includePrivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includePrivate)), __LINE__);
        }
        $this->includePrivate = $includePrivate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalendarPublish
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
