<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarItem StructType
 * Meta informations extracted from the WSDL
 * - maxOccurs: 3
 * - minOccurs: 0
 * - type: xs:unsignedInt
 * @subpackage Structs
 */
class CalendarItem extends Mail
{
    /**
     * The rdate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecurrenceDateType
     */
    public $rdate;
    /**
     * The rrule
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecurrenceRule
     */
    public $rrule;
    /**
     * The exdate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecurrenceDateType
     */
    public $exdate;
    /**
     * The recurrenceKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:recurrenceKey
     * @var int
     */
    public $recurrenceKey;
    /**
     * The iCalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iCalId;
    /**
     * Constructor method for CalendarItem
     * @uses CalendarItem::setRdate()
     * @uses CalendarItem::setRrule()
     * @uses CalendarItem::setExdate()
     * @uses CalendarItem::setRecurrenceKey()
     * @uses CalendarItem::setICalId()
     * @param \StructType\RecurrenceDateType $rdate
     * @param \StructType\RecurrenceRule $rrule
     * @param \StructType\RecurrenceDateType $exdate
     * @param int $recurrenceKey
     * @param string $iCalId
     */
    public function __construct(\StructType\RecurrenceDateType $rdate = null, \StructType\RecurrenceRule $rrule = null, \StructType\RecurrenceDateType $exdate = null, $recurrenceKey = null, $iCalId = null)
    {
        $this
            ->setRdate($rdate)
            ->setRrule($rrule)
            ->setExdate($exdate)
            ->setRecurrenceKey($recurrenceKey)
            ->setICalId($iCalId);
    }
    /**
     * Get rdate value
     * @return \StructType\RecurrenceDateType|null
     */
    public function getRdate()
    {
        return $this->rdate;
    }
    /**
     * Set rdate value
     * @param \StructType\RecurrenceDateType $rdate
     * @return \StructType\CalendarItem
     */
    public function setRdate(\StructType\RecurrenceDateType $rdate = null)
    {
        $this->rdate = $rdate;
        return $this;
    }
    /**
     * Get rrule value
     * @return \StructType\RecurrenceRule|null
     */
    public function getRrule()
    {
        return $this->rrule;
    }
    /**
     * Set rrule value
     * @param \StructType\RecurrenceRule $rrule
     * @return \StructType\CalendarItem
     */
    public function setRrule(\StructType\RecurrenceRule $rrule = null)
    {
        $this->rrule = $rrule;
        return $this;
    }
    /**
     * Get exdate value
     * @return \StructType\RecurrenceDateType|null
     */
    public function getExdate()
    {
        return $this->exdate;
    }
    /**
     * Set exdate value
     * @param \StructType\RecurrenceDateType $exdate
     * @return \StructType\CalendarItem
     */
    public function setExdate(\StructType\RecurrenceDateType $exdate = null)
    {
        $this->exdate = $exdate;
        return $this;
    }
    /**
     * Get recurrenceKey value
     * @return int|null
     */
    public function getRecurrenceKey()
    {
        return $this->recurrenceKey;
    }
    /**
     * Set recurrenceKey value
     * @param int $recurrenceKey
     * @return \StructType\CalendarItem
     */
    public function setRecurrenceKey($recurrenceKey = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceKey) && !is_numeric($recurrenceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurrenceKey)), __LINE__);
        }
        $this->recurrenceKey = $recurrenceKey;
        return $this;
    }
    /**
     * Get iCalId value
     * @return string|null
     */
    public function getICalId()
    {
        return $this->iCalId;
    }
    /**
     * Set iCalId value
     * @param string $iCalId
     * @return \StructType\CalendarItem
     */
    public function setICalId($iCalId = null)
    {
        // validation for constraint: string
        if (!is_null($iCalId) && !is_string($iCalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iCalId)), __LINE__);
        }
        $this->iCalId = $iCalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalendarItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
