<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalHost StructType
 * @subpackage Structs
 */
class CalHost extends Item
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * The host
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Host
     */
    public $host;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for CalHost
     * @uses CalHost::setDescription()
     * @uses CalHost::setHost()
     * @uses CalHost::setURL()
     * @param string $description
     * @param \StructType\Host $host
     * @param string $uRL
     */
    public function __construct($description = null, \StructType\Host $host = null, $uRL = null)
    {
        $this
            ->setDescription($description)
            ->setHost($host)
            ->setURL($uRL);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CalHost
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get host value
     * @return \StructType\Host|null
     */
    public function getHost()
    {
        return $this->host;
    }
    /**
     * Set host value
     * @param \StructType\Host $host
     * @return \StructType\CalHost
     */
    public function setHost(\StructType\Host $host = null)
    {
        $this->host = $host;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\CalHost
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalHost
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
