<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentID StructType
 * Meta informations extracted from the WSDL
 * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
 * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
 * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
 * - minOccurs: 0
 * - pattern: [^@]+(@*)?
 * - type: xs:string
 * @subpackage Structs
 */
class AttachmentID extends AbstractStructBase
{
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $_;
    /**
     * The itemReference
     * @var bool
     */
    public $itemReference;
    /**
     * Constructor method for AttachmentID
     * @uses AttachmentID::set_()
     * @uses AttachmentID::setItemReference()
     * @param string $_
     * @param bool $itemReference
     */
    public function __construct($_ = null, $itemReference = null)
    {
        $this
            ->set_($_)
            ->setItemReference($itemReference);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\AttachmentID
     */
    public function set_($_ = null)
    {
        // validation for constraint: pattern
        if (is_scalar($_) && !preg_match('/[^@]+(@*)?/', $_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($_, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get itemReference value
     * @return bool|null
     */
    public function getItemReference()
    {
        return $this->itemReference;
    }
    /**
     * Set itemReference value
     * @param bool $itemReference
     * @return \StructType\AttachmentID
     */
    public function setItemReference($itemReference = null)
    {
        // validation for constraint: boolean
        if (!is_null($itemReference) && !is_bool($itemReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($itemReference)), __LINE__);
        }
        $this->itemReference = $itemReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachmentID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
