<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressBookList StructType
 * @subpackage Structs
 */
class AddressBookList extends AbstractStructBase
{
    /**
     * The book
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AddressBook[]
     */
    public $book;
    /**
     * Constructor method for AddressBookList
     * @uses AddressBookList::setBook()
     * @param \StructType\AddressBook[] $book
     */
    public function __construct(array $book = array())
    {
        $this
            ->setBook($book);
    }
    /**
     * Get book value
     * @return \StructType\AddressBook[]|null
     */
    public function getBook()
    {
        return $this->book;
    }
    /**
     * Set book value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressBook[] $book
     * @return \StructType\AddressBookList
     */
    public function setBook(array $book = array())
    {
        foreach ($book as $addressBookListBookItem) {
            // validation for constraint: itemType
            if (!$addressBookListBookItem instanceof \StructType\AddressBook) {
                throw new \InvalidArgumentException(sprintf('The book property can only contain items of \StructType\AddressBook, "%s" given', is_object($addressBookListBookItem) ? get_class($addressBookListBookItem) : gettype($addressBookListBookItem)), __LINE__);
            }
        }
        $this->book = $book;
        return $this;
    }
    /**
     * Add item to book value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressBook $item
     * @return \StructType\AddressBookList
     */
    public function addToBook(\StructType\AddressBook $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressBook) {
            throw new \InvalidArgumentException(sprintf('The book property can only contain items of \StructType\AddressBook, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->book[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressBookList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
