<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessRightEntry StructType
 * @subpackage Structs
 */
class AccessRightEntry extends NameAndEmail
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - ref: tns:id
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The appointment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessRight
     */
    public $appointment;
    /**
     * The mail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessRight
     */
    public $mail;
    /**
     * The misc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessMiscRight
     */
    public $misc;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessRight
     */
    public $note;
    /**
     * The task
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessRight
     */
    public $task;
    /**
     * Constructor method for AccessRightEntry
     * @uses AccessRightEntry::setId()
     * @uses AccessRightEntry::setAppointment()
     * @uses AccessRightEntry::setMail()
     * @uses AccessRightEntry::setMisc()
     * @uses AccessRightEntry::setNote()
     * @uses AccessRightEntry::setTask()
     * @param string $id
     * @param \StructType\AccessRight $appointment
     * @param \StructType\AccessRight $mail
     * @param \StructType\AccessMiscRight $misc
     * @param \StructType\AccessRight $note
     * @param \StructType\AccessRight $task
     */
    public function __construct($id = null, \StructType\AccessRight $appointment = null, \StructType\AccessRight $mail = null, \StructType\AccessMiscRight $misc = null, \StructType\AccessRight $note = null, \StructType\AccessRight $task = null)
    {
        $this
            ->setId($id)
            ->setAppointment($appointment)
            ->setMail($mail)
            ->setMisc($misc)
            ->setNote($note)
            ->setTask($task);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AccessRightEntry
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get appointment value
     * @return \StructType\AccessRight|null
     */
    public function getAppointment()
    {
        return $this->appointment;
    }
    /**
     * Set appointment value
     * @param \StructType\AccessRight $appointment
     * @return \StructType\AccessRightEntry
     */
    public function setAppointment(\StructType\AccessRight $appointment = null)
    {
        $this->appointment = $appointment;
        return $this;
    }
    /**
     * Get mail value
     * @return \StructType\AccessRight|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param \StructType\AccessRight $mail
     * @return \StructType\AccessRightEntry
     */
    public function setMail(\StructType\AccessRight $mail = null)
    {
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get misc value
     * @return \StructType\AccessMiscRight|null
     */
    public function getMisc()
    {
        return $this->misc;
    }
    /**
     * Set misc value
     * @param \StructType\AccessMiscRight $misc
     * @return \StructType\AccessRightEntry
     */
    public function setMisc(\StructType\AccessMiscRight $misc = null)
    {
        $this->misc = $misc;
        return $this;
    }
    /**
     * Get note value
     * @return \StructType\AccessRight|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param \StructType\AccessRight $note
     * @return \StructType\AccessRightEntry
     */
    public function setNote(\StructType\AccessRight $note = null)
    {
        $this->note = $note;
        return $this;
    }
    /**
     * Get task value
     * @return \StructType\AccessRight|null
     */
    public function getTask()
    {
        return $this->task;
    }
    /**
     * Set task value
     * @param \StructType\AccessRight $task
     * @return \StructType\AccessRightEntry
     */
    public function setTask(\StructType\AccessRight $task = null)
    {
        $this->task = $task;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessRightEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
