<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessRight StructType
 * @subpackage Structs
 */
class AccessRight extends AbstractStructBase
{
    /**
     * The read
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $read;
    /**
     * The write
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $write;
    /**
     * Constructor method for AccessRight
     * @uses AccessRight::setRead()
     * @uses AccessRight::setWrite()
     * @param bool $read
     * @param bool $write
     */
    public function __construct($read = null, $write = null)
    {
        $this
            ->setRead($read)
            ->setWrite($write);
    }
    /**
     * Get read value
     * @return bool|null
     */
    public function getRead()
    {
        return $this->read;
    }
    /**
     * Set read value
     * @param bool $read
     * @return \StructType\AccessRight
     */
    public function setRead($read = null)
    {
        // validation for constraint: boolean
        if (!is_null($read) && !is_bool($read)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($read)), __LINE__);
        }
        $this->read = $read;
        return $this;
    }
    /**
     * Get write value
     * @return bool|null
     */
    public function getWrite()
    {
        return $this->write;
    }
    /**
     * Set write value
     * @param bool $write
     * @return \StructType\AccessRight
     */
    public function setWrite($write = null)
    {
        // validation for constraint: boolean
        if (!is_null($write) && !is_bool($write)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($write)), __LINE__);
        }
        $this->write = $write;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessRight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
