<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for acceptRequest StructType
 * @subpackage Structs
 */
class AcceptRequest extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The items
     * @var \StructType\ItemRefList
     */
    public $items;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The acceptLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $acceptLevel;
    /**
     * The recurrenceAllInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recurrenceAllInstances;
    /**
     * The alarm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Alarm
     */
    public $alarm;
    /**
     * Constructor method for acceptRequest
     * @uses AcceptRequest::setContainer()
     * @uses AcceptRequest::setItems()
     * @uses AcceptRequest::setComment()
     * @uses AcceptRequest::setAcceptLevel()
     * @uses AcceptRequest::setRecurrenceAllInstances()
     * @uses AcceptRequest::setAlarm()
     * @param string $container
     * @param \StructType\ItemRefList $items
     * @param string $comment
     * @param string $acceptLevel
     * @param int $recurrenceAllInstances
     * @param \StructType\Alarm $alarm
     */
    public function __construct($container = null, \StructType\ItemRefList $items = null, $comment = null, $acceptLevel = null, $recurrenceAllInstances = null, \StructType\Alarm $alarm = null)
    {
        $this
            ->setContainer($container)
            ->setItems($items)
            ->setComment($comment)
            ->setAcceptLevel($acceptLevel)
            ->setRecurrenceAllInstances($recurrenceAllInstances)
            ->setAlarm($alarm);
    }
    /**
     * Get container value
     * @return string
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\AcceptRequest
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get items value
     * @return \StructType\ItemRefList|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \StructType\ItemRefList $items
     * @return \StructType\AcceptRequest
     */
    public function setItems(\StructType\ItemRefList $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\AcceptRequest
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get acceptLevel value
     * @return string|null
     */
    public function getAcceptLevel()
    {
        return $this->acceptLevel;
    }
    /**
     * Set acceptLevel value
     * @uses \EnumType\AcceptLevel::valueIsValid()
     * @uses \EnumType\AcceptLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptLevel
     * @return \StructType\AcceptRequest
     */
    public function setAcceptLevel($acceptLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AcceptLevel::valueIsValid($acceptLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $acceptLevel, implode(', ', \EnumType\AcceptLevel::getValidValues())), __LINE__);
        }
        $this->acceptLevel = $acceptLevel;
        return $this;
    }
    /**
     * Get recurrenceAllInstances value
     * @return int|null
     */
    public function getRecurrenceAllInstances()
    {
        return $this->recurrenceAllInstances;
    }
    /**
     * Set recurrenceAllInstances value
     * @param int $recurrenceAllInstances
     * @return \StructType\AcceptRequest
     */
    public function setRecurrenceAllInstances($recurrenceAllInstances = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceAllInstances) && !is_numeric($recurrenceAllInstances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurrenceAllInstances)), __LINE__);
        }
        $this->recurrenceAllInstances = $recurrenceAllInstances;
        return $this;
    }
    /**
     * Get alarm value
     * @return \StructType\Alarm|null
     */
    public function getAlarm()
    {
        return $this->alarm;
    }
    /**
     * Set alarm value
     * @param \StructType\Alarm $alarm
     * @return \StructType\AcceptRequest
     */
    public function setAlarm(\StructType\Alarm $alarm = null)
    {
        $this->alarm = $alarm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
