<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Sets the GwTrace SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $gwTrace
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGwTrace($gwTrace, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'gwTrace', $gwTrace, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named loginRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: boolean
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginRequest $loginReq
     * @return \StructType\LoginResponse|bool
     */
    public function loginRequest(\StructType\LoginRequest $loginReq)
    {
        try {
            $this->setResult(self::getSoapClient()->loginRequest($loginReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
