<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Session SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $session
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSession($session, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'session', $session, $mustUnderstand, $actor);
    }
    /**
     * Sets the GwTrace SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $gwTrace
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGwTrace($gwTrace, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'gwTrace', $gwTrace, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getAccountListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountListRequest $getAccountListReq
     * @return \StructType\GetAccountListResponse|bool
     */
    public function getAccountListRequest(\StructType\GetAccountListRequest $getAccountListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getAccountListRequest($getAccountListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAddressBookListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddressBookListRequest $getAddressBookListReq
     * @return \StructType\GetAddressBookListResponse|bool
     */
    public function getAddressBookListRequest(\StructType\GetAddressBookListRequest $getAddressBookListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getAddressBookListRequest($getAddressBookListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArchiveItemsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetArchiveItemsRequest $getArchiveItemsReq
     * @return \StructType\GetArchiveItemsResponse|bool
     */
    public function getArchiveItemsRequest(\StructType\GetArchiveItemsRequest $getArchiveItemsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getArchiveItemsRequest($getArchiveItemsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAttachmentRequestMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAttachmentRequest $getAttachmentReq
     * @return \StructType\GetAttachmentResponse|bool
     */
    public function getAttachmentRequestMessage(\StructType\GetAttachmentRequest $getAttachmentReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getAttachmentRequestMessage($getAttachmentReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCategoryListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCategoryListRequest $getCategoryListReq
     * @return \StructType\GetCategoryListResponse|bool
     */
    public function getCategoryListRequest(\StructType\GetCategoryListRequest $getCategoryListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getCategoryListRequest($getCategoryListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContactHistoryFilterRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContactHistoryFilterRequest $getContactHistoryFilterReq
     * @return \StructType\GetContactHistoryFilterResponse|bool
     */
    public function getContactHistoryFilterRequest(\StructType\GetContactHistoryFilterRequest $getContactHistoryFilterReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getContactHistoryFilterRequest($getContactHistoryFilterReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomListRequest $getCustomListReq
     * @return \StructType\GetCustomListResponse|bool
     */
    public function getCustomListRequest(\StructType\GetCustomListRequest $getCustomListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getCustomListRequest($getCustomListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeltasRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeltasRequest $getDeltasReq
     * @return \StructType\GetDeltasResponse|bool
     */
    public function getDeltasRequest(\StructType\GetDeltasRequest $getDeltasReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeltasRequest($getDeltasReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeltaInfoRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeltaInfoRequest $getDeltaInfoReq
     * @return \StructType\GetDeltaInfoResponse|bool
     */
    public function getDeltaInfoRequest(\StructType\GetDeltaInfoRequest $getDeltaInfoReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeltaInfoRequest($getDeltaInfoReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDiskSpaceUsageRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDiskSpaceUsageRequest $getDiskSpaceUsageReq
     * @return \StructType\GetDiskSpaceUsageResponse|bool
     */
    public function getDiskSpaceUsageRequest(\StructType\GetDiskSpaceUsageRequest $getDiskSpaceUsageReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getDiskSpaceUsageRequest($getDiskSpaceUsageReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDocumentTypeListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDocumentTypeListRequest $getDocumentTypeListReq
     * @return \StructType\GetDocumentTypeListResponse|bool
     */
    public function getDocumentTypeListRequest(\StructType\GetDocumentTypeListRequest $getDocumentTypeListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getDocumentTypeListRequest($getDocumentTypeListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFolderRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFolderRequest $getFolderReq
     * @return \StructType\GetFolderResponse|bool
     */
    public function getFolderRequest(\StructType\GetFolderRequest $getFolderReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getFolderRequest($getFolderReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFolderListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFolderListRequest $getFolderListReq
     * @return \StructType\GetFolderListResponse|bool
     */
    public function getFolderListRequest(\StructType\GetFolderListRequest $getFolderListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getFolderListRequest($getFolderListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFreeBusyRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFreeBusyRequest $getFreeBusyReq
     * @return \StructType\GetFreeBusyResponse|bool
     */
    public function getFreeBusyRequest(\StructType\GetFreeBusyRequest $getFreeBusyReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getFreeBusyRequest($getFreeBusyReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getItemRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemRequest $getItemReq
     * @return \StructType\GetItemResponse|bool
     */
    public function getItemRequest(\StructType\GetItemRequest $getItemReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getItemRequest($getItemReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getItemsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemsRequest $getItemsReq
     * @return \StructType\GetItemsResponse|bool
     */
    public function getItemsRequest(\StructType\GetItemsRequest $getItemsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getItemsRequest($getItemsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJunkEntriesRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetJunkEntriesRequest $getJunkEntriesReq
     * @return \StructType\GetJunkEntriesResponse|bool
     */
    public function getJunkEntriesRequest(\StructType\GetJunkEntriesRequest $getJunkEntriesReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getJunkEntriesRequest($getJunkEntriesReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJunkMailSettingsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetJunkMailSettingsRequest $getJunkMailSettingsReq
     * @return \StructType\GetJunkMailSettingsResponse|bool
     */
    public function getJunkMailSettingsRequest(\StructType\GetJunkMailSettingsRequest $getJunkMailSettingsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getJunkMailSettingsRequest($getJunkMailSettingsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLibraryItemRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryItemRequest $getLibraryItemReq
     * @return \StructType\GetLibraryItemResponse|bool
     */
    public function getLibraryItemRequest(\StructType\GetLibraryItemRequest $getLibraryItemReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getLibraryItemRequest($getLibraryItemReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLibraryListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLibraryListRequest $getLibraryListReq
     * @return \StructType\GetLibraryListResponse|bool
     */
    public function getLibraryListRequest(\StructType\GetLibraryListRequest $getLibraryListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getLibraryListRequest($getLibraryListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMemberOfRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMemberOfRequest $getMemberOfReq
     * @return \StructType\GetMemberOfResponse|bool
     */
    public function getMemberOfRequest(\StructType\GetMemberOfRequest $getMemberOfReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getMemberOfRequest($getMemberOfReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNotifyListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNotifyListRequest $getNotifyListReq
     * @return \StructType\GetNotifyListResponse|bool
     */
    public function getNotifyListRequest(\StructType\GetNotifyListRequest $getNotifyListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getNotifyListRequest($getNotifyListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getQuickMessagesRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuickMessagesRequest $getQuickMessagesReq
     * @return \StructType\GetQuickMessagesResponse|bool
     */
    public function getQuickMessagesRequest(\StructType\GetQuickMessagesRequest $getQuickMessagesReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getQuickMessagesRequest($getQuickMessagesReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProxyAccessListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProxyAccessListRequest $getProxyAccessListReq
     * @return \StructType\GetProxyAccessListResponse|bool
     */
    public function getProxyAccessListRequest(\StructType\GetProxyAccessListRequest $getProxyAccessListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getProxyAccessListRequest($getProxyAccessListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProxyListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProxyListRequest $getProxyListReq
     * @return \StructType\GetProxyListResponse|bool
     */
    public function getProxyListRequest(\StructType\GetProxyListRequest $getProxyListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getProxyListRequest($getProxyListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRuleListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRuleListRequest $getRuleListReq
     * @return \StructType\GetRuleListResponse|bool
     */
    public function getRuleListRequest(\StructType\GetRuleListRequest $getRuleListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getRuleListRequest($getRuleListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSettingsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSettingsRequest $getSettingsReq
     * @return \StructType\GetSettingsResponse|bool
     */
    public function getSettingsRequest(\StructType\GetSettingsRequest $getSettingsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getSettingsRequest($getSettingsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSignaturesRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSignaturesRequest $getSignaturesReq
     * @return \StructType\GetSignaturesResponse|bool
     */
    public function getSignaturesRequest(\StructType\GetSignaturesRequest $getSignaturesReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getSignaturesRequest($getSignaturesReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStringRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStringRequest $getStringReq
     * @return \StructType\GetStringResponse|bool
     */
    public function getStringRequest(\StructType\GetStringRequest $getStringReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getStringRequest($getStringReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimestampRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTimestampRequest $getTimestampReq
     * @return \StructType\GetTimestampResponse|bool
     */
    public function getTimestampRequest(\StructType\GetTimestampRequest $getTimestampReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getTimestampRequest($getTimestampReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimezoneListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTimezoneListRequest $getTimezoneListReq
     * @return \StructType\GetTimezoneListResponse|bool
     */
    public function getTimezoneListRequest(\StructType\GetTimezoneListRequest $getTimezoneListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getTimezoneListRequest($getTimezoneListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUnreadRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnreadRequest $getUnreadReq
     * @return \StructType\GetUnreadResponse|bool
     */
    public function getUnreadRequest(\StructType\GetUnreadRequest $getUnreadReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getUnreadRequest($getUnreadReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserListRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserListRequest $getUserListReq
     * @return \StructType\GetUserListResponse|bool
     */
    public function getUserListRequest(\StructType\GetUserListRequest $getUserListReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserListRequest($getUserListReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEventConfigurationRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEventConfigurationRequest $getEventConfigurationReq
     * @return \StructType\GetEventConfigurationResponse|bool
     */
    public function getEventConfigurationRequest(\StructType\GetEventConfigurationRequest $getEventConfigurationReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getEventConfigurationRequest($getEventConfigurationReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEventsRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEventsRequest $getEventsReq
     * @return \StructType\GetEventsResponse|bool
     */
    public function getEventsRequest(\StructType\GetEventsRequest $getEventsReq)
    {
        try {
            $this->setResult(self::getSoapClient()->getEventsRequest($getEventsReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountListResponse|\StructType\GetAddressBookListResponse|\StructType\GetArchiveItemsResponse|\StructType\GetAttachmentResponse|\StructType\GetCategoryListResponse|\StructType\GetContactHistoryFilterResponse|\StructType\GetCustomListResponse|\StructType\GetDeltaInfoResponse|\StructType\GetDeltasResponse|\StructType\GetDiskSpaceUsageResponse|\StructType\GetDocumentTypeListResponse|\StructType\GetEventConfigurationResponse|\StructType\GetEventsResponse|\StructType\GetFolderListResponse|\StructType\GetFolderResponse|\StructType\GetFreeBusyResponse|\StructType\GetItemResponse|\StructType\GetItemsResponse|\StructType\GetJunkEntriesResponse|\StructType\GetJunkMailSettingsResponse|\StructType\GetLibraryItemResponse|\StructType\GetLibraryListResponse|\StructType\GetMemberOfResponse|\StructType\GetNotifyListResponse|\StructType\GetProxyAccessListResponse|\StructType\GetProxyListResponse|\StructType\GetQuickMessagesResponse|\StructType\GetRuleListResponse|\StructType\GetSettingsResponse|\StructType\GetSignaturesResponse|\StructType\GetStringResponse|\StructType\GetTimestampResponse|\StructType\GetTimezoneListResponse|\StructType\GetUnreadResponse|\StructType\GetUserListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
