<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Sets the Session SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $session
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSession($session, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'session', $session, $mustUnderstand, $actor);
    }
    /**
     * Sets the GwTrace SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $gwTrace
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderGwTrace($gwTrace, $nameSpace = 'http://schemas.novell.com/2005/01/GroupWise/types', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'gwTrace', $gwTrace, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named executeRuleRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: session, gwTrace
     * - SOAPHeaderNamespaces: http://schemas.novell.com/2005/01/GroupWise/types, http://schemas.novell.com/2005/01/GroupWise/types
     * - SOAPHeaderTypes: string, boolean
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExecuteRuleRequest $executeRuleReq
     * @return \StructType\ExecuteRuleResponse|bool
     */
    public function executeRuleRequest(\StructType\ExecuteRuleRequest $executeRuleReq)
    {
        try {
            $this->setResult(self::getSoapClient()->executeRuleRequest($executeRuleReq));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExecuteRuleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
