<?php

namespace EnumType;

/**
 * This class stands for Visibility EnumType
 * @subpackage Enumerations
 */
class Visibility
{
    /**
     * Constant for value 'PostOffice'
     * @return string 'PostOffice'
     */
    const VALUE_POST_OFFICE = 'PostOffice';
    /**
     * Constant for value 'Domain'
     * @return string 'Domain'
     */
    const VALUE_DOMAIN = 'Domain';
    /**
     * Constant for value 'System'
     * @return string 'System'
     */
    const VALUE_SYSTEM = 'System';
    /**
     * Constant for value 'Unlisted'
     * @return string 'Unlisted'
     */
    const VALUE_UNLISTED = 'Unlisted';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_POST_OFFICE
     * @uses self::VALUE_DOMAIN
     * @uses self::VALUE_SYSTEM
     * @uses self::VALUE_UNLISTED
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_POST_OFFICE,
            self::VALUE_DOMAIN,
            self::VALUE_SYSTEM,
            self::VALUE_UNLISTED,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
