<?php

namespace EnumType;

/**
 * This class stands for ViewType EnumType
 * @subpackage Enumerations
 */
class ViewType
{
    /**
     * Constant for value 'details'
     * @return string 'details'
     */
    const VALUE_DETAILS = 'details';
    /**
     * Constant for value 'largeIcons'
     * @return string 'largeIcons'
     */
    const VALUE_LARGE_ICONS = 'largeIcons';
    /**
     * Constant for value 'smallIcon'
     * @return string 'smallIcon'
     */
    const VALUE_SMALL_ICON = 'smallIcon';
    /**
     * Constant for value 'list'
     * @return string 'list'
     */
    const VALUE_LIST = 'list';
    /**
     * Constant for value 'discussion'
     * @return string 'discussion'
     */
    const VALUE_DISCUSSION = 'discussion';
    /**
     * Constant for value 'calendar'
     * @return string 'calendar'
     */
    const VALUE_CALENDAR = 'calendar';
    /**
     * Constant for value 'tasklist'
     * @return string 'tasklist'
     */
    const VALUE_TASKLIST = 'tasklist';
    /**
     * Constant for value 'panel'
     * @return string 'panel'
     */
    const VALUE_PANEL = 'panel';
    /**
     * Constant for value 'addressCards'
     * @return string 'addressCards'
     */
    const VALUE_ADDRESS_CARDS = 'addressCards';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DETAILS
     * @uses self::VALUE_LARGE_ICONS
     * @uses self::VALUE_SMALL_ICON
     * @uses self::VALUE_LIST
     * @uses self::VALUE_DISCUSSION
     * @uses self::VALUE_CALENDAR
     * @uses self::VALUE_TASKLIST
     * @uses self::VALUE_PANEL
     * @uses self::VALUE_ADDRESS_CARDS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DETAILS,
            self::VALUE_LARGE_ICONS,
            self::VALUE_SMALL_ICON,
            self::VALUE_LIST,
            self::VALUE_DISCUSSION,
            self::VALUE_CALENDAR,
            self::VALUE_TASKLIST,
            self::VALUE_PANEL,
            self::VALUE_ADDRESS_CARDS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
