<?php

namespace EnumType;

/**
 * This class stands for VersionStatus EnumType
 * @subpackage Enumerations
 */
class VersionStatus
{
    /**
     * Constant for value 'available'
     * @return string 'available'
     */
    const VALUE_AVAILABLE = 'available';
    /**
     * Constant for value 'checkedOut'
     * @return string 'checkedOut'
     */
    const VALUE_CHECKED_OUT = 'checkedOut';
    /**
     * Constant for value 'inUse'
     * @return string 'inUse'
     */
    const VALUE_IN_USE = 'inUse';
    /**
     * Constant for value 'deleted'
     * @return string 'deleted'
     */
    const VALUE_DELETED = 'deleted';
    /**
     * Constant for value 'archived'
     * @return string 'archived'
     */
    const VALUE_ARCHIVED = 'archived';
    /**
     * Constant for value 'massInUse'
     * @return string 'massInUse'
     */
    const VALUE_MASS_IN_USE = 'massInUse';
    /**
     * Constant for value 'unavailable'
     * @return string 'unavailable'
     */
    const VALUE_UNAVAILABLE = 'unavailable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_CHECKED_OUT
     * @uses self::VALUE_IN_USE
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_ARCHIVED
     * @uses self::VALUE_MASS_IN_USE
     * @uses self::VALUE_UNAVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVAILABLE,
            self::VALUE_CHECKED_OUT,
            self::VALUE_IN_USE,
            self::VALUE_DELETED,
            self::VALUE_ARCHIVED,
            self::VALUE_MASS_IN_USE,
            self::VALUE_UNAVAILABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
