<?php

namespace EnumType;

/**
 * This class stands for TextCase EnumType
 * @subpackage Enumerations
 */
class TextCase
{
    /**
     * Constant for value 'Lower'
     * @return string 'Lower'
     */
    const VALUE_LOWER = 'Lower';
    /**
     * Constant for value 'Mixed'
     * @return string 'Mixed'
     */
    const VALUE_MIXED = 'Mixed';
    /**
     * Constant for value 'Upper'
     * @return string 'Upper'
     */
    const VALUE_UPPER = 'Upper';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOWER
     * @uses self::VALUE_MIXED
     * @uses self::VALUE_UPPER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOWER,
            self::VALUE_MIXED,
            self::VALUE_UPPER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
