<?php

namespace EnumType;

/**
 * This class stands for PollInfoType EnumType
 * @subpackage Enumerations
 */
class PollInfoType
{
    /**
     * Constant for value 'add'
     * @return string 'add'
     */
    const VALUE_ADD = 'add';
    /**
     * Constant for value 'preModify'
     * @return string 'preModify'
     */
    const VALUE_PRE_MODIFY = 'preModify';
    /**
     * Constant for value 'postModify'
     * @return string 'postModify'
     */
    const VALUE_POST_MODIFY = 'postModify';
    /**
     * Constant for value 'purge'
     * @return string 'purge'
     */
    const VALUE_PURGE = 'purge';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD
     * @uses self::VALUE_PRE_MODIFY
     * @uses self::VALUE_POST_MODIFY
     * @uses self::VALUE_PURGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD,
            self::VALUE_PRE_MODIFY,
            self::VALUE_POST_MODIFY,
            self::VALUE_PURGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
