<?php

namespace EnumType;

/**
 * This class stands for PhoneNumberType EnumType
 * @subpackage Enumerations
 */
class PhoneNumberType
{
    /**
     * Constant for value 'Fax'
     * @return string 'Fax'
     */
    const VALUE_FAX = 'Fax';
    /**
     * Constant for value 'Home'
     * @return string 'Home'
     */
    const VALUE_HOME = 'Home';
    /**
     * Constant for value 'Mobile'
     * @return string 'Mobile'
     */
    const VALUE_MOBILE = 'Mobile';
    /**
     * Constant for value 'Office'
     * @return string 'Office'
     */
    const VALUE_OFFICE = 'Office';
    /**
     * Constant for value 'Pager'
     * @return string 'Pager'
     */
    const VALUE_PAGER = 'Pager';
    /**
     * Constant for value 'CallBack'
     * @return string 'CallBack'
     */
    const VALUE_CALL_BACK = 'CallBack';
    /**
     * Constant for value 'Office2'
     * @return string 'Office2'
     */
    const VALUE_OFFICE_2 = 'Office2';
    /**
     * Constant for value 'Radio'
     * @return string 'Radio'
     */
    const VALUE_RADIO = 'Radio';
    /**
     * Constant for value 'Car'
     * @return string 'Car'
     */
    const VALUE_CAR = 'Car';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Telex'
     * @return string 'Telex'
     */
    const VALUE_TELEX = 'Telex';
    /**
     * Constant for value 'ISDN'
     * @return string 'ISDN'
     */
    const VALUE_ISDN = 'ISDN';
    /**
     * Constant for value 'Assistant'
     * @return string 'Assistant'
     */
    const VALUE_ASSISTANT = 'Assistant';
    /**
     * Constant for value 'Home2'
     * @return string 'Home2'
     */
    const VALUE_HOME_2 = 'Home2';
    /**
     * Constant for value 'FaxOffice'
     * @return string 'FaxOffice'
     */
    const VALUE_FAX_OFFICE = 'FaxOffice';
    /**
     * Constant for value 'FaxHome'
     * @return string 'FaxHome'
     */
    const VALUE_FAX_HOME = 'FaxHome';
    /**
     * Constant for value 'TTYTDD'
     * @return string 'TTYTDD'
     */
    const VALUE_TTYTDD = 'TTYTDD';
    /**
     * Constant for value 'Company'
     * @return string 'Company'
     */
    const VALUE_COMPANY = 'Company';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FAX
     * @uses self::VALUE_HOME
     * @uses self::VALUE_MOBILE
     * @uses self::VALUE_OFFICE
     * @uses self::VALUE_PAGER
     * @uses self::VALUE_CALL_BACK
     * @uses self::VALUE_OFFICE_2
     * @uses self::VALUE_RADIO
     * @uses self::VALUE_CAR
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_TELEX
     * @uses self::VALUE_ISDN
     * @uses self::VALUE_ASSISTANT
     * @uses self::VALUE_HOME_2
     * @uses self::VALUE_FAX_OFFICE
     * @uses self::VALUE_FAX_HOME
     * @uses self::VALUE_TTYTDD
     * @uses self::VALUE_COMPANY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FAX,
            self::VALUE_HOME,
            self::VALUE_MOBILE,
            self::VALUE_OFFICE,
            self::VALUE_PAGER,
            self::VALUE_CALL_BACK,
            self::VALUE_OFFICE_2,
            self::VALUE_RADIO,
            self::VALUE_CAR,
            self::VALUE_OTHER,
            self::VALUE_TELEX,
            self::VALUE_ISDN,
            self::VALUE_ASSISTANT,
            self::VALUE_HOME_2,
            self::VALUE_FAX_OFFICE,
            self::VALUE_FAX_HOME,
            self::VALUE_TTYTDD,
            self::VALUE_COMPANY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
