<?php

namespace EnumType;

/**
 * This class stands for NotificationType EnumType
 * @subpackage Enumerations
 */
class NotificationType
{
    /**
     * Constant for value 'SharedAddressBook'
     * @return string 'SharedAddressBook'
     */
    const VALUE_SHARED_ADDRESS_BOOK = 'SharedAddressBook';
    /**
     * Constant for value 'SharedFolder'
     * @return string 'SharedFolder'
     */
    const VALUE_SHARED_FOLDER = 'SharedFolder';
    /**
     * Constant for value 'SharedCalendar'
     * @return string 'SharedCalendar'
     */
    const VALUE_SHARED_CALENDAR = 'SharedCalendar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SHARED_ADDRESS_BOOK
     * @uses self::VALUE_SHARED_FOLDER
     * @uses self::VALUE_SHARED_CALENDAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHARED_ADDRESS_BOOK,
            self::VALUE_SHARED_FOLDER,
            self::VALUE_SHARED_CALENDAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
