<?php

namespace EnumType;

/**
 * This class stands for MessageType EnumType
 * @subpackage Enumerations
 */
class MessageType
{
    /**
     * Constant for value 'Appointment'
     * @return string 'Appointment'
     */
    const VALUE_APPOINTMENT = 'Appointment';
    /**
     * Constant for value 'CalendarItem'
     * @return string 'CalendarItem'
     */
    const VALUE_CALENDAR_ITEM = 'CalendarItem';
    /**
     * Constant for value 'DocumentReference'
     * @return string 'DocumentReference'
     */
    const VALUE_DOCUMENT_REFERENCE = 'DocumentReference';
    /**
     * Constant for value 'Mail'
     * @return string 'Mail'
     */
    const VALUE_MAIL = 'Mail';
    /**
     * Constant for value 'Note'
     * @return string 'Note'
     */
    const VALUE_NOTE = 'Note';
    /**
     * Constant for value 'PhoneMessage'
     * @return string 'PhoneMessage'
     */
    const VALUE_PHONE_MESSAGE = 'PhoneMessage';
    /**
     * Constant for value 'Task'
     * @return string 'Task'
     */
    const VALUE_TASK = 'Task';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPOINTMENT
     * @uses self::VALUE_CALENDAR_ITEM
     * @uses self::VALUE_DOCUMENT_REFERENCE
     * @uses self::VALUE_MAIL
     * @uses self::VALUE_NOTE
     * @uses self::VALUE_PHONE_MESSAGE
     * @uses self::VALUE_TASK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPOINTMENT,
            self::VALUE_CALENDAR_ITEM,
            self::VALUE_DOCUMENT_REFERENCE,
            self::VALUE_MAIL,
            self::VALUE_NOTE,
            self::VALUE_PHONE_MESSAGE,
            self::VALUE_TASK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
