<?php

namespace EnumType;

/**
 * This class stands for LinkType EnumType
 * @subpackage Enumerations
 */
class LinkType
{
    /**
     * Constant for value 'forward'
     * @return string 'forward'
     */
    const VALUE_FORWARD = 'forward';
    /**
     * Constant for value 'reply'
     * @return string 'reply'
     */
    const VALUE_REPLY = 'reply';
    /**
     * Constant for value 'draft'
     * @return string 'draft'
     */
    const VALUE_DRAFT = 'draft';
    /**
     * Constant for value 'resend'
     * @return string 'resend'
     */
    const VALUE_RESEND = 'resend';
    /**
     * Constant for value 'counter'
     * @return string 'counter'
     */
    const VALUE_COUNTER = 'counter';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FORWARD
     * @uses self::VALUE_REPLY
     * @uses self::VALUE_DRAFT
     * @uses self::VALUE_RESEND
     * @uses self::VALUE_COUNTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FORWARD,
            self::VALUE_REPLY,
            self::VALUE_DRAFT,
            self::VALUE_RESEND,
            self::VALUE_COUNTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
