<?php

namespace EnumType;

/**
 * This class stands for JunkMatchType EnumType
 * @subpackage Enumerations
 */
class JunkMatchType
{
    /**
     * Constant for value 'email'
     * @return string 'email'
     */
    const VALUE_EMAIL = 'email';
    /**
     * Constant for value 'domain'
     * @return string 'domain'
     */
    const VALUE_DOMAIN = 'domain';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_DOMAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMAIL,
            self::VALUE_DOMAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
