<?php

namespace EnumType;

/**
 * This class stands for ItemType EnumType
 * @subpackage Enumerations
 */
class ItemType
{
    /**
     * Constant for value 'AddressBookItem'
     * @return string 'AddressBookItem'
     */
    const VALUE_ADDRESS_BOOK_ITEM = 'AddressBookItem';
    /**
     * Constant for value 'Appointment'
     * @return string 'Appointment'
     */
    const VALUE_APPOINTMENT = 'Appointment';
    /**
     * Constant for value 'CalendarItem'
     * @return string 'CalendarItem'
     */
    const VALUE_CALENDAR_ITEM = 'CalendarItem';
    /**
     * Constant for value 'Contact'
     * @return string 'Contact'
     */
    const VALUE_CONTACT = 'Contact';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'Mail'
     * @return string 'Mail'
     */
    const VALUE_MAIL = 'Mail';
    /**
     * Constant for value 'Note'
     * @return string 'Note'
     */
    const VALUE_NOTE = 'Note';
    /**
     * Constant for value 'Organization'
     * @return string 'Organization'
     */
    const VALUE_ORGANIZATION = 'Organization';
    /**
     * Constant for value 'PhoneMessage'
     * @return string 'PhoneMessage'
     */
    const VALUE_PHONE_MESSAGE = 'PhoneMessage';
    /**
     * Constant for value 'Resource'
     * @return string 'Resource'
     */
    const VALUE_RESOURCE = 'Resource';
    /**
     * Constant for value 'Task'
     * @return string 'Task'
     */
    const VALUE_TASK = 'Task';
    /**
     * Constant for value 'DocumentRef'
     * @return string 'DocumentRef'
     */
    const VALUE_DOCUMENT_REF = 'DocumentRef';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADDRESS_BOOK_ITEM
     * @uses self::VALUE_APPOINTMENT
     * @uses self::VALUE_CALENDAR_ITEM
     * @uses self::VALUE_CONTACT
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_MAIL
     * @uses self::VALUE_NOTE
     * @uses self::VALUE_ORGANIZATION
     * @uses self::VALUE_PHONE_MESSAGE
     * @uses self::VALUE_RESOURCE
     * @uses self::VALUE_TASK
     * @uses self::VALUE_DOCUMENT_REF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADDRESS_BOOK_ITEM,
            self::VALUE_APPOINTMENT,
            self::VALUE_CALENDAR_ITEM,
            self::VALUE_CONTACT,
            self::VALUE_GROUP,
            self::VALUE_MAIL,
            self::VALUE_NOTE,
            self::VALUE_ORGANIZATION,
            self::VALUE_PHONE_MESSAGE,
            self::VALUE_RESOURCE,
            self::VALUE_TASK,
            self::VALUE_DOCUMENT_REF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
