<?php

namespace EnumType;

/**
 * This class stands for ItemSecurity EnumType
 * @subpackage Enumerations
 */
class ItemSecurity
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Proprietary'
     * @return string 'Proprietary'
     */
    const VALUE_PROPRIETARY = 'Proprietary';
    /**
     * Constant for value 'Confidential'
     * @return string 'Confidential'
     */
    const VALUE_CONFIDENTIAL = 'Confidential';
    /**
     * Constant for value 'Secret'
     * @return string 'Secret'
     */
    const VALUE_SECRET = 'Secret';
    /**
     * Constant for value 'TopSecret'
     * @return string 'TopSecret'
     */
    const VALUE_TOP_SECRET = 'TopSecret';
    /**
     * Constant for value 'ForYourEyesOnly'
     * @return string 'ForYourEyesOnly'
     */
    const VALUE_FOR_YOUR_EYES_ONLY = 'ForYourEyesOnly';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_PROPRIETARY
     * @uses self::VALUE_CONFIDENTIAL
     * @uses self::VALUE_SECRET
     * @uses self::VALUE_TOP_SECRET
     * @uses self::VALUE_FOR_YOUR_EYES_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_PROPRIETARY,
            self::VALUE_CONFIDENTIAL,
            self::VALUE_SECRET,
            self::VALUE_TOP_SECRET,
            self::VALUE_FOR_YOUR_EYES_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
