<?php

namespace EnumType;

/**
 * This class stands for Execution EnumType
 * @subpackage Enumerations
 */
class Execution
{
    /**
     * Constant for value 'Startup'
     * @return string 'Startup'
     */
    const VALUE_STARTUP = 'Startup';
    /**
     * Constant for value 'Exit'
     * @return string 'Exit'
     */
    const VALUE_EXIT = 'Exit';
    /**
     * Constant for value 'New'
     * @return string 'New'
     */
    const VALUE_NEW = 'New';
    /**
     * Constant for value 'FolderOpen'
     * @return string 'FolderOpen'
     */
    const VALUE_FOLDER_OPEN = 'FolderOpen';
    /**
     * Constant for value 'FolderClose'
     * @return string 'FolderClose'
     */
    const VALUE_FOLDER_CLOSE = 'FolderClose';
    /**
     * Constant for value 'FolderNew'
     * @return string 'FolderNew'
     */
    const VALUE_FOLDER_NEW = 'FolderNew';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STARTUP
     * @uses self::VALUE_EXIT
     * @uses self::VALUE_NEW
     * @uses self::VALUE_FOLDER_OPEN
     * @uses self::VALUE_FOLDER_CLOSE
     * @uses self::VALUE_FOLDER_NEW
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_USER
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STARTUP,
            self::VALUE_EXIT,
            self::VALUE_NEW,
            self::VALUE_FOLDER_OPEN,
            self::VALUE_FOLDER_CLOSE,
            self::VALUE_FOLDER_NEW,
            self::VALUE_COMPLETED,
            self::VALUE_USER,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
