<?php

namespace EnumType;

/**
 * This class stands for DistributionType EnumType
 * @subpackage Enumerations
 */
class DistributionType
{
    /**
     * Constant for value 'TO'
     * @return string 'TO'
     */
    const VALUE_TO = 'TO';
    /**
     * Constant for value 'CC'
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Constant for value 'BC'
     * @return string 'BC'
     */
    const VALUE_BC = 'BC';
    /**
     * Constant for value 'replyTo'
     * @return string 'replyTo'
     */
    const VALUE_REPLY_TO = 'replyTo';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TO
     * @uses self::VALUE_CC
     * @uses self::VALUE_BC
     * @uses self::VALUE_REPLY_TO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TO,
            self::VALUE_CC,
            self::VALUE_BC,
            self::VALUE_REPLY_TO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
