<?php

namespace EnumType;

/**
 * This class stands for DisplaySettingsType EnumType
 * @subpackage Enumerations
 */
class DisplaySettingsType
{
    /**
     * Constant for value 'Folder'
     * @return string 'Folder'
     */
    const VALUE_FOLDER = 'Folder';
    /**
     * Constant for value 'FolderDefault'
     * @return string 'FolderDefault'
     */
    const VALUE_FOLDER_DEFAULT = 'FolderDefault';
    /**
     * Constant for value 'Panel'
     * @return string 'Panel'
     */
    const VALUE_PANEL = 'Panel';
    /**
     * Constant for value 'PanelTemplate'
     * @return string 'PanelTemplate'
     */
    const VALUE_PANEL_TEMPLATE = 'PanelTemplate';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FOLDER
     * @uses self::VALUE_FOLDER_DEFAULT
     * @uses self::VALUE_PANEL
     * @uses self::VALUE_PANEL_TEMPLATE
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FOLDER,
            self::VALUE_FOLDER_DEFAULT,
            self::VALUE_PANEL,
            self::VALUE_PANEL_TEMPLATE,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
