<?php

namespace EnumType;

/**
 * This class stands for DisplayFolderType EnumType
 * @subpackage Enumerations
 */
class DisplayFolderType
{
    /**
     * Constant for value 'Calendar'
     * @return string 'Calendar'
     */
    const VALUE_CALENDAR = 'Calendar';
    /**
     * Constant for value 'Checklist'
     * @return string 'Checklist'
     */
    const VALUE_CHECKLIST = 'Checklist';
    /**
     * Constant for value 'Contacts'
     * @return string 'Contacts'
     */
    const VALUE_CONTACTS = 'Contacts';
    /**
     * Constant for value 'ContactsPersonal'
     * @return string 'ContactsPersonal'
     */
    const VALUE_CONTACTS_PERSONAL = 'ContactsPersonal';
    /**
     * Constant for value 'ContactsOffice'
     * @return string 'ContactsOffice'
     */
    const VALUE_CONTACTS_OFFICE = 'ContactsOffice';
    /**
     * Constant for value 'ContactsUserDefined'
     * @return string 'ContactsUserDefined'
     */
    const VALUE_CONTACTS_USER_DEFINED = 'ContactsUserDefined';
    /**
     * Constant for value 'DiscussionThread'
     * @return string 'DiscussionThread'
     */
    const VALUE_DISCUSSION_THREAD = 'DiscussionThread';
    /**
     * Constant for value 'DiscussionThreadList'
     * @return string 'DiscussionThreadList'
     */
    const VALUE_DISCUSSION_THREAD_LIST = 'DiscussionThreadList';
    /**
     * Constant for value 'Documents'
     * @return string 'Documents'
     */
    const VALUE_DOCUMENTS = 'Documents';
    /**
     * Constant for value 'Draft'
     * @return string 'Draft'
     */
    const VALUE_DRAFT = 'Draft';
    /**
     * Constant for value 'Mailbox'
     * @return string 'Mailbox'
     */
    const VALUE_MAILBOX = 'Mailbox';
    /**
     * Constant for value 'MAPIRoot'
     * @return string 'MAPIRoot'
     */
    const VALUE_MAPIROOT = 'MAPIRoot';
    /**
     * Constant for value 'Newsgroup'
     * @return string 'Newsgroup'
     */
    const VALUE_NEWSGROUP = 'Newsgroup';
    /**
     * Constant for value 'NNTPServer'
     * @return string 'NNTPServer'
     */
    const VALUE_NNTPSERVER = 'NNTPServer';
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'PanelCalendar'
     * @return string 'PanelCalendar'
     */
    const VALUE_PANEL_CALENDAR = 'PanelCalendar';
    /**
     * Constant for value 'PanelChecklist'
     * @return string 'PanelChecklist'
     */
    const VALUE_PANEL_CHECKLIST = 'PanelChecklist';
    /**
     * Constant for value 'PanelRecentActivity'
     * @return string 'PanelRecentActivity'
     */
    const VALUE_PANEL_RECENT_ACTIVITY = 'PanelRecentActivity';
    /**
     * Constant for value 'PanelSummaryCalendar'
     * @return string 'PanelSummaryCalendar'
     */
    const VALUE_PANEL_SUMMARY_CALENDAR = 'PanelSummaryCalendar';
    /**
     * Constant for value 'PanelUnreadItems'
     * @return string 'PanelUnreadItems'
     */
    const VALUE_PANEL_UNREAD_ITEMS = 'PanelUnreadItems';
    /**
     * Constant for value 'Query'
     * @return string 'Query'
     */
    const VALUE_QUERY = 'Query';
    /**
     * Constant for value 'QueryResults'
     * @return string 'QueryResults'
     */
    const VALUE_QUERY_RESULTS = 'QueryResults';
    /**
     * Constant for value 'SentItems'
     * @return string 'SentItems'
     */
    const VALUE_SENT_ITEMS = 'SentItems';
    /**
     * Constant for value 'TaskList'
     * @return string 'TaskList'
     */
    const VALUE_TASK_LIST = 'TaskList';
    /**
     * Constant for value 'Toolbar'
     * @return string 'Toolbar'
     */
    const VALUE_TOOLBAR = 'Toolbar';
    /**
     * Constant for value 'Trash'
     * @return string 'Trash'
     */
    const VALUE_TRASH = 'Trash';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'UserDefined'
     * @return string 'UserDefined'
     */
    const VALUE_USER_DEFINED = 'UserDefined';
    /**
     * Constant for value 'VersionList'
     * @return string 'VersionList'
     */
    const VALUE_VERSION_LIST = 'VersionList';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CALENDAR
     * @uses self::VALUE_CHECKLIST
     * @uses self::VALUE_CONTACTS
     * @uses self::VALUE_CONTACTS_PERSONAL
     * @uses self::VALUE_CONTACTS_OFFICE
     * @uses self::VALUE_CONTACTS_USER_DEFINED
     * @uses self::VALUE_DISCUSSION_THREAD
     * @uses self::VALUE_DISCUSSION_THREAD_LIST
     * @uses self::VALUE_DOCUMENTS
     * @uses self::VALUE_DRAFT
     * @uses self::VALUE_MAILBOX
     * @uses self::VALUE_MAPIROOT
     * @uses self::VALUE_NEWSGROUP
     * @uses self::VALUE_NNTPSERVER
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_PANEL_CALENDAR
     * @uses self::VALUE_PANEL_CHECKLIST
     * @uses self::VALUE_PANEL_RECENT_ACTIVITY
     * @uses self::VALUE_PANEL_SUMMARY_CALENDAR
     * @uses self::VALUE_PANEL_UNREAD_ITEMS
     * @uses self::VALUE_QUERY
     * @uses self::VALUE_QUERY_RESULTS
     * @uses self::VALUE_SENT_ITEMS
     * @uses self::VALUE_TASK_LIST
     * @uses self::VALUE_TOOLBAR
     * @uses self::VALUE_TRASH
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_USER_DEFINED
     * @uses self::VALUE_VERSION_LIST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CALENDAR,
            self::VALUE_CHECKLIST,
            self::VALUE_CONTACTS,
            self::VALUE_CONTACTS_PERSONAL,
            self::VALUE_CONTACTS_OFFICE,
            self::VALUE_CONTACTS_USER_DEFINED,
            self::VALUE_DISCUSSION_THREAD,
            self::VALUE_DISCUSSION_THREAD_LIST,
            self::VALUE_DOCUMENTS,
            self::VALUE_DRAFT,
            self::VALUE_MAILBOX,
            self::VALUE_MAPIROOT,
            self::VALUE_NEWSGROUP,
            self::VALUE_NNTPSERVER,
            self::VALUE_NORMAL,
            self::VALUE_PANEL_CALENDAR,
            self::VALUE_PANEL_CHECKLIST,
            self::VALUE_PANEL_RECENT_ACTIVITY,
            self::VALUE_PANEL_SUMMARY_CALENDAR,
            self::VALUE_PANEL_UNREAD_ITEMS,
            self::VALUE_QUERY,
            self::VALUE_QUERY_RESULTS,
            self::VALUE_SENT_ITEMS,
            self::VALUE_TASK_LIST,
            self::VALUE_TOOLBAR,
            self::VALUE_TRASH,
            self::VALUE_UNKNOWN,
            self::VALUE_USER_DEFINED,
            self::VALUE_VERSION_LIST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
