<?php

namespace EnumType;

/**
 * This class stands for DeltaSyncType EnumType
 * @subpackage Enumerations
 */
class DeltaSyncType
{
    /**
     * Constant for value 'add'
     * @return string 'add'
     */
    const VALUE_ADD = 'add';
    /**
     * Constant for value 'delete'
     * @return string 'delete'
     */
    const VALUE_DELETE = 'delete';
    /**
     * Constant for value 'update'
     * @return string 'update'
     */
    const VALUE_UPDATE = 'update';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_UPDATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD,
            self::VALUE_DELETE,
            self::VALUE_UPDATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
