<?php

namespace EnumType;

/**
 * This class stands for CursorSeek EnumType
 * @subpackage Enumerations
 */
class CursorSeek
{
    /**
     * Constant for value 'current'
     * @return string 'current'
     */
    const VALUE_CURRENT = 'current';
    /**
     * Constant for value 'start'
     * @return string 'start'
     */
    const VALUE_START = 'start';
    /**
     * Constant for value 'end'
     * @return string 'end'
     */
    const VALUE_END = 'end';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CURRENT
     * @uses self::VALUE_START
     * @uses self::VALUE_END
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CURRENT,
            self::VALUE_START,
            self::VALUE_END,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
