<?php

namespace EnumType;

/**
 * This class stands for CalendarPublishRange EnumType
 * @subpackage Enumerations
 */
class CalendarPublishRange
{
    /**
     * Constant for value 'EntireCalendar'
     * @return string 'EntireCalendar'
     */
    const VALUE_ENTIRE_CALENDAR = 'EntireCalendar';
    /**
     * Constant for value 'Relative'
     * @return string 'Relative'
     */
    const VALUE_RELATIVE = 'Relative';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENTIRE_CALENDAR
     * @uses self::VALUE_RELATIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTIRE_CALENDAR,
            self::VALUE_RELATIVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
