<?php

namespace EnumType;

/**
 * This class stands for AttachmentFlags EnumType
 * @subpackage Enumerations
 */
class AttachmentFlags
{
    /**
     * Constant for value 'ComputeHash'
     * @return string 'ComputeHash'
     */
    const VALUE_COMPUTE_HASH = 'ComputeHash';
    /**
     * Constant for value 'Deflate'
     * @return string 'Deflate'
     */
    const VALUE_DEFLATE = 'Deflate';
    /**
     * Constant for value 'ReturnData'
     * @return string 'ReturnData'
     */
    const VALUE_RETURN_DATA = 'ReturnData';
    /**
     * Constant for value 'ReturnPath'
     * @return string 'ReturnPath'
     */
    const VALUE_RETURN_PATH = 'ReturnPath';
    /**
     * Constant for value 'Mime'
     * @return string 'Mime'
     */
    const VALUE_MIME = 'Mime';
    /**
     * Constant for value 'Diag'
     * @return string 'Diag'
     */
    const VALUE_DIAG = 'Diag';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMPUTE_HASH
     * @uses self::VALUE_DEFLATE
     * @uses self::VALUE_RETURN_DATA
     * @uses self::VALUE_RETURN_PATH
     * @uses self::VALUE_MIME
     * @uses self::VALUE_DIAG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMPUTE_HASH,
            self::VALUE_DEFLATE,
            self::VALUE_RETURN_DATA,
            self::VALUE_RETURN_PATH,
            self::VALUE_MIME,
            self::VALUE_DIAG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
