<?php

namespace EnumType;

/**
 * This class stands for AcceptLevel EnumType
 * @subpackage Enumerations
 */
class AcceptLevel
{
    /**
     * Constant for value 'Free'
     * @return string 'Free'
     */
    const VALUE_FREE = 'Free';
    /**
     * Constant for value 'Tentative'
     * @return string 'Tentative'
     */
    const VALUE_TENTATIVE = 'Tentative';
    /**
     * Constant for value 'Busy'
     * @return string 'Busy'
     */
    const VALUE_BUSY = 'Busy';
    /**
     * Constant for value 'OutOfOffice'
     * @return string 'OutOfOffice'
     */
    const VALUE_OUT_OF_OFFICE = 'OutOfOffice';
    /**
     * Constant for value 'NoDisplay'
     * @return string 'NoDisplay'
     */
    const VALUE_NO_DISPLAY = 'NoDisplay';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FREE
     * @uses self::VALUE_TENTATIVE
     * @uses self::VALUE_BUSY
     * @uses self::VALUE_OUT_OF_OFFICE
     * @uses self::VALUE_NO_DISPLAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FREE,
            self::VALUE_TENTATIVE,
            self::VALUE_BUSY,
            self::VALUE_OUT_OF_OFFICE,
            self::VALUE_NO_DISPLAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
