<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleSubscription StructType
 * @subpackage Structs
 */
class VehicleSubscription extends SubcontractedResultStrategy
{
    /**
     * The SubscriptionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SubscriptionId;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Company
     */
    public $Company;
    /**
     * The VehicleStrategy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleStrategy
     */
    public $VehicleStrategy;
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SubscriptionPeriod
     */
    public $Period;
    /**
     * Constructor method for VehicleSubscription
     * @uses VehicleSubscription::setSubscriptionId()
     * @uses VehicleSubscription::setIsActive()
     * @uses VehicleSubscription::setCompany()
     * @uses VehicleSubscription::setVehicleStrategy()
     * @uses VehicleSubscription::setPeriod()
     * @param int $subscriptionId
     * @param bool $isActive
     * @param \StructType\Company $company
     * @param \StructType\VehicleStrategy $vehicleStrategy
     * @param \StructType\SubscriptionPeriod $period
     */
    public function __construct($subscriptionId = null, $isActive = null, \StructType\Company $company = null, \StructType\VehicleStrategy $vehicleStrategy = null, \StructType\SubscriptionPeriod $period = null)
    {
        $this
            ->setSubscriptionId($subscriptionId)
            ->setIsActive($isActive)
            ->setCompany($company)
            ->setVehicleStrategy($vehicleStrategy)
            ->setPeriod($period);
    }
    /**
     * Get SubscriptionId value
     * @return int
     */
    public function getSubscriptionId()
    {
        return $this->SubscriptionId;
    }
    /**
     * Set SubscriptionId value
     * @param int $subscriptionId
     * @return \StructType\VehicleSubscription
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionId) && !is_numeric($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subscriptionId)), __LINE__);
        }
        $this->SubscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\VehicleSubscription
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Company value
     * @return \StructType\Company|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \StructType\Company $company
     * @return \StructType\VehicleSubscription
     */
    public function setCompany(\StructType\Company $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get VehicleStrategy value
     * @return \StructType\VehicleStrategy|null
     */
    public function getVehicleStrategy()
    {
        return $this->VehicleStrategy;
    }
    /**
     * Set VehicleStrategy value
     * @param \StructType\VehicleStrategy $vehicleStrategy
     * @return \StructType\VehicleSubscription
     */
    public function setVehicleStrategy(\StructType\VehicleStrategy $vehicleStrategy = null)
    {
        $this->VehicleStrategy = $vehicleStrategy;
        return $this;
    }
    /**
     * Get Period value
     * @return \StructType\SubscriptionPeriod|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \StructType\SubscriptionPeriod $period
     * @return \StructType\VehicleSubscription
     */
    public function setPeriod(\StructType\SubscriptionPeriod $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleSubscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
