<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleProfile StructType
 * @subpackage Structs
 */
class VehicleProfile extends AbstractStructBase
{
    /**
     * The ProfileId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ProfileId;
    /**
     * The ProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileName;
    /**
     * Constructor method for VehicleProfile
     * @uses VehicleProfile::setProfileId()
     * @uses VehicleProfile::setProfileName()
     * @param int $profileId
     * @param string $profileName
     */
    public function __construct($profileId = null, $profileName = null)
    {
        $this
            ->setProfileId($profileId)
            ->setProfileName($profileName);
    }
    /**
     * Get ProfileId value
     * @return int
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\VehicleProfile
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get ProfileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->ProfileName;
    }
    /**
     * Set ProfileName value
     * @param string $profileName
     * @return \StructType\VehicleProfile
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileName)), __LINE__);
        }
        $this->ProfileName = $profileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
