<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleObcInfo StructType
 * @subpackage Structs
 */
class VehicleObcInfo extends AbstractStructBase
{
    /**
     * The UpdateProgress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $UpdateProgress;
    /**
     * The IBC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IBC;
    /**
     * The DeviceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeviceType;
    /**
     * The SoftwareBehaviour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareBehaviour;
    /**
     * The SoftwareVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareVersion;
    /**
     * The InstructionSetVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstructionSetVersion;
    /**
     * The Planningfeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleSoftwareInformation
     */
    public $Planningfeatures;
    /**
     * The ResponseImage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseImage;
    /**
     * The ModemChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemChannelID;
    /**
     * Constructor method for VehicleObcInfo
     * @uses VehicleObcInfo::setUpdateProgress()
     * @uses VehicleObcInfo::setIBC()
     * @uses VehicleObcInfo::setDeviceType()
     * @uses VehicleObcInfo::setSoftwareBehaviour()
     * @uses VehicleObcInfo::setSoftwareVersion()
     * @uses VehicleObcInfo::setInstructionSetVersion()
     * @uses VehicleObcInfo::setPlanningfeatures()
     * @uses VehicleObcInfo::setResponseImage()
     * @uses VehicleObcInfo::setModemChannelID()
     * @param int $updateProgress
     * @param int $iBC
     * @param string $deviceType
     * @param string $softwareBehaviour
     * @param string $softwareVersion
     * @param string $instructionSetVersion
     * @param \StructType\VehicleSoftwareInformation $planningfeatures
     * @param string $responseImage
     * @param string $modemChannelID
     */
    public function __construct($updateProgress = null, $iBC = null, $deviceType = null, $softwareBehaviour = null, $softwareVersion = null, $instructionSetVersion = null, \StructType\VehicleSoftwareInformation $planningfeatures = null, $responseImage = null, $modemChannelID = null)
    {
        $this
            ->setUpdateProgress($updateProgress)
            ->setIBC($iBC)
            ->setDeviceType($deviceType)
            ->setSoftwareBehaviour($softwareBehaviour)
            ->setSoftwareVersion($softwareVersion)
            ->setInstructionSetVersion($instructionSetVersion)
            ->setPlanningfeatures($planningfeatures)
            ->setResponseImage($responseImage)
            ->setModemChannelID($modemChannelID);
    }
    /**
     * Get UpdateProgress value
     * @return int
     */
    public function getUpdateProgress()
    {
        return $this->UpdateProgress;
    }
    /**
     * Set UpdateProgress value
     * @param int $updateProgress
     * @return \StructType\VehicleObcInfo
     */
    public function setUpdateProgress($updateProgress = null)
    {
        // validation for constraint: int
        if (!is_null($updateProgress) && !is_numeric($updateProgress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($updateProgress)), __LINE__);
        }
        $this->UpdateProgress = $updateProgress;
        return $this;
    }
    /**
     * Get IBC value
     * @return int
     */
    public function getIBC()
    {
        return $this->IBC;
    }
    /**
     * Set IBC value
     * @param int $iBC
     * @return \StructType\VehicleObcInfo
     */
    public function setIBC($iBC = null)
    {
        // validation for constraint: int
        if (!is_null($iBC) && !is_numeric($iBC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iBC)), __LINE__);
        }
        $this->IBC = $iBC;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \EnumType\EnumDeviceType::valueIsValid()
     * @uses \EnumType\EnumDeviceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \StructType\VehicleObcInfo
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumDeviceType::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceType, implode(', ', \EnumType\EnumDeviceType::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get SoftwareBehaviour value
     * @return string|null
     */
    public function getSoftwareBehaviour()
    {
        return $this->SoftwareBehaviour;
    }
    /**
     * Set SoftwareBehaviour value
     * @param string $softwareBehaviour
     * @return \StructType\VehicleObcInfo
     */
    public function setSoftwareBehaviour($softwareBehaviour = null)
    {
        // validation for constraint: string
        if (!is_null($softwareBehaviour) && !is_string($softwareBehaviour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($softwareBehaviour)), __LINE__);
        }
        $this->SoftwareBehaviour = $softwareBehaviour;
        return $this;
    }
    /**
     * Get SoftwareVersion value
     * @return string|null
     */
    public function getSoftwareVersion()
    {
        return $this->SoftwareVersion;
    }
    /**
     * Set SoftwareVersion value
     * @param string $softwareVersion
     * @return \StructType\VehicleObcInfo
     */
    public function setSoftwareVersion($softwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($softwareVersion) && !is_string($softwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($softwareVersion)), __LINE__);
        }
        $this->SoftwareVersion = $softwareVersion;
        return $this;
    }
    /**
     * Get InstructionSetVersion value
     * @return string|null
     */
    public function getInstructionSetVersion()
    {
        return $this->InstructionSetVersion;
    }
    /**
     * Set InstructionSetVersion value
     * @param string $instructionSetVersion
     * @return \StructType\VehicleObcInfo
     */
    public function setInstructionSetVersion($instructionSetVersion = null)
    {
        // validation for constraint: string
        if (!is_null($instructionSetVersion) && !is_string($instructionSetVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instructionSetVersion)), __LINE__);
        }
        $this->InstructionSetVersion = $instructionSetVersion;
        return $this;
    }
    /**
     * Get Planningfeatures value
     * @return \StructType\VehicleSoftwareInformation|null
     */
    public function getPlanningfeatures()
    {
        return $this->Planningfeatures;
    }
    /**
     * Set Planningfeatures value
     * @param \StructType\VehicleSoftwareInformation $planningfeatures
     * @return \StructType\VehicleObcInfo
     */
    public function setPlanningfeatures(\StructType\VehicleSoftwareInformation $planningfeatures = null)
    {
        $this->Planningfeatures = $planningfeatures;
        return $this;
    }
    /**
     * Get ResponseImage value
     * @return string|null
     */
    public function getResponseImage()
    {
        return $this->ResponseImage;
    }
    /**
     * Set ResponseImage value
     * @param string $responseImage
     * @return \StructType\VehicleObcInfo
     */
    public function setResponseImage($responseImage = null)
    {
        // validation for constraint: string
        if (!is_null($responseImage) && !is_string($responseImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseImage)), __LINE__);
        }
        $this->ResponseImage = $responseImage;
        return $this;
    }
    /**
     * Get ModemChannelID value
     * @return string|null
     */
    public function getModemChannelID()
    {
        return $this->ModemChannelID;
    }
    /**
     * Set ModemChannelID value
     * @param string $modemChannelID
     * @return \StructType\VehicleObcInfo
     */
    public function setModemChannelID($modemChannelID = null)
    {
        // validation for constraint: string
        if (!is_null($modemChannelID) && !is_string($modemChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modemChannelID)), __LINE__);
        }
        $this->ModemChannelID = $modemChannelID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleObcInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
