<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleItem StructType
 * @subpackage Structs
 */
class VehicleItem extends AbstractStructBase
{
    /**
     * The TransicsId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsId;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The LicensePlate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter;
    /**
     * The FormattedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * Constructor method for VehicleItem
     * @uses VehicleItem::setTransicsId()
     * @uses VehicleItem::setIsActive()
     * @uses VehicleItem::setId()
     * @uses VehicleItem::setCode()
     * @uses VehicleItem::setLicensePlate()
     * @uses VehicleItem::setFilter()
     * @uses VehicleItem::setFormattedName()
     * @param int $transicsId
     * @param bool $isActive
     * @param string $id
     * @param string $code
     * @param string $licensePlate
     * @param string $filter
     * @param string $formattedName
     */
    public function __construct($transicsId = null, $isActive = null, $id = null, $code = null, $licensePlate = null, $filter = null, $formattedName = null)
    {
        $this
            ->setTransicsId($transicsId)
            ->setIsActive($isActive)
            ->setId($id)
            ->setCode($code)
            ->setLicensePlate($licensePlate)
            ->setFilter($filter)
            ->setFormattedName($formattedName);
    }
    /**
     * Get TransicsId value
     * @return int
     */
    public function getTransicsId()
    {
        return $this->TransicsId;
    }
    /**
     * Set TransicsId value
     * @param int $transicsId
     * @return \StructType\VehicleItem
     */
    public function setTransicsId($transicsId = null)
    {
        // validation for constraint: int
        if (!is_null($transicsId) && !is_numeric($transicsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsId)), __LINE__);
        }
        $this->TransicsId = $transicsId;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\VehicleItem
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\VehicleItem
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\VehicleItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\VehicleItem
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get Filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param string $filter
     * @return \StructType\VehicleItem
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filter)), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\VehicleItem
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
