<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleETAInfo StructType
 * @subpackage Structs
 */
class VehicleETAInfo extends AbstractStructBase
{
    /**
     * The PrevETA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PrevETA;
    /**
     * The ETAStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ETAStatus;
    /**
     * The DistanceETA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DistanceETA;
    /**
     * The ETA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ETA;
    /**
     * The PositionDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $PositionDestination;
    /**
     * The PositionInfoDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PositionInfoDestination;
    /**
     * Constructor method for VehicleETAInfo
     * @uses VehicleETAInfo::setPrevETA()
     * @uses VehicleETAInfo::setETAStatus()
     * @uses VehicleETAInfo::setDistanceETA()
     * @uses VehicleETAInfo::setETA()
     * @uses VehicleETAInfo::setPositionDestination()
     * @uses VehicleETAInfo::setPositionInfoDestination()
     * @param string $prevETA
     * @param string $eTAStatus
     * @param int $distanceETA
     * @param string $eTA
     * @param \StructType\Position $positionDestination
     * @param string $positionInfoDestination
     */
    public function __construct($prevETA = null, $eTAStatus = null, $distanceETA = null, $eTA = null, \StructType\Position $positionDestination = null, $positionInfoDestination = null)
    {
        $this
            ->setPrevETA($prevETA)
            ->setETAStatus($eTAStatus)
            ->setDistanceETA($distanceETA)
            ->setETA($eTA)
            ->setPositionDestination($positionDestination)
            ->setPositionInfoDestination($positionInfoDestination);
    }
    /**
     * Get PrevETA value
     * @return string
     */
    public function getPrevETA()
    {
        return $this->PrevETA;
    }
    /**
     * Set PrevETA value
     * @param string $prevETA
     * @return \StructType\VehicleETAInfo
     */
    public function setPrevETA($prevETA = null)
    {
        // validation for constraint: string
        if (!is_null($prevETA) && !is_string($prevETA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prevETA)), __LINE__);
        }
        $this->PrevETA = $prevETA;
        return $this;
    }
    /**
     * Get ETAStatus value
     * @return string
     */
    public function getETAStatus()
    {
        return $this->ETAStatus;
    }
    /**
     * Set ETAStatus value
     * @uses \EnumType\EnumETAStatus::valueIsValid()
     * @uses \EnumType\EnumETAStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eTAStatus
     * @return \StructType\VehicleETAInfo
     */
    public function setETAStatus($eTAStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumETAStatus::valueIsValid($eTAStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eTAStatus, implode(', ', \EnumType\EnumETAStatus::getValidValues())), __LINE__);
        }
        $this->ETAStatus = $eTAStatus;
        return $this;
    }
    /**
     * Get DistanceETA value
     * @return int
     */
    public function getDistanceETA()
    {
        return $this->DistanceETA;
    }
    /**
     * Set DistanceETA value
     * @param int $distanceETA
     * @return \StructType\VehicleETAInfo
     */
    public function setDistanceETA($distanceETA = null)
    {
        // validation for constraint: int
        if (!is_null($distanceETA) && !is_numeric($distanceETA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distanceETA)), __LINE__);
        }
        $this->DistanceETA = $distanceETA;
        return $this;
    }
    /**
     * Get ETA value
     * @return string
     */
    public function getETA()
    {
        return $this->ETA;
    }
    /**
     * Set ETA value
     * @param string $eTA
     * @return \StructType\VehicleETAInfo
     */
    public function setETA($eTA = null)
    {
        // validation for constraint: string
        if (!is_null($eTA) && !is_string($eTA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eTA)), __LINE__);
        }
        $this->ETA = $eTA;
        return $this;
    }
    /**
     * Get PositionDestination value
     * @return \StructType\Position|null
     */
    public function getPositionDestination()
    {
        return $this->PositionDestination;
    }
    /**
     * Set PositionDestination value
     * @param \StructType\Position $positionDestination
     * @return \StructType\VehicleETAInfo
     */
    public function setPositionDestination(\StructType\Position $positionDestination = null)
    {
        $this->PositionDestination = $positionDestination;
        return $this;
    }
    /**
     * Get PositionInfoDestination value
     * @return string|null
     */
    public function getPositionInfoDestination()
    {
        return $this->PositionInfoDestination;
    }
    /**
     * Set PositionInfoDestination value
     * @param string $positionInfoDestination
     * @return \StructType\VehicleETAInfo
     */
    public function setPositionInfoDestination($positionInfoDestination = null)
    {
        // validation for constraint: string
        if (!is_null($positionInfoDestination) && !is_string($positionInfoDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($positionInfoDestination)), __LINE__);
        }
        $this->PositionInfoDestination = $positionInfoDestination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleETAInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
