<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Update StructType
 * @subpackage Structs
 */
class Update extends SubcontractedVehicleStrategy
{
    /**
     * The SubscriptionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SubscriptionId;
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $From;
    /**
     * The Until
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Until;
    /**
     * The IdentifierVehicleStrategy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleStrategy
     */
    public $IdentifierVehicleStrategy;
    /**
     * The CompanyStrategySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyStrategySelection
     */
    public $CompanyStrategySelection;
    /**
     * Constructor method for Update
     * @uses Update::setSubscriptionId()
     * @uses Update::setFrom()
     * @uses Update::setUntil()
     * @uses Update::setIdentifierVehicleStrategy()
     * @uses Update::setCompanyStrategySelection()
     * @param int $subscriptionId
     * @param string $from
     * @param string $until
     * @param \StructType\IdentifierVehicleStrategy $identifierVehicleStrategy
     * @param \StructType\CompanyStrategySelection $companyStrategySelection
     */
    public function __construct($subscriptionId = null, $from = null, $until = null, \StructType\IdentifierVehicleStrategy $identifierVehicleStrategy = null, \StructType\CompanyStrategySelection $companyStrategySelection = null)
    {
        $this
            ->setSubscriptionId($subscriptionId)
            ->setFrom($from)
            ->setUntil($until)
            ->setIdentifierVehicleStrategy($identifierVehicleStrategy)
            ->setCompanyStrategySelection($companyStrategySelection);
    }
    /**
     * Get SubscriptionId value
     * @return int
     */
    public function getSubscriptionId()
    {
        return $this->SubscriptionId;
    }
    /**
     * Set SubscriptionId value
     * @param int $subscriptionId
     * @return \StructType\Update
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionId) && !is_numeric($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subscriptionId)), __LINE__);
        }
        $this->SubscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Get From value
     * @return string
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\Update
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get Until value
     * @return string
     */
    public function getUntil()
    {
        return $this->Until;
    }
    /**
     * Set Until value
     * @param string $until
     * @return \StructType\Update
     */
    public function setUntil($until = null)
    {
        // validation for constraint: string
        if (!is_null($until) && !is_string($until)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($until)), __LINE__);
        }
        $this->Until = $until;
        return $this;
    }
    /**
     * Get IdentifierVehicleStrategy value
     * @return \StructType\IdentifierVehicleStrategy|null
     */
    public function getIdentifierVehicleStrategy()
    {
        return $this->IdentifierVehicleStrategy;
    }
    /**
     * Set IdentifierVehicleStrategy value
     * @param \StructType\IdentifierVehicleStrategy $identifierVehicleStrategy
     * @return \StructType\Update
     */
    public function setIdentifierVehicleStrategy(\StructType\IdentifierVehicleStrategy $identifierVehicleStrategy = null)
    {
        $this->IdentifierVehicleStrategy = $identifierVehicleStrategy;
        return $this;
    }
    /**
     * Get CompanyStrategySelection value
     * @return \StructType\CompanyStrategySelection|null
     */
    public function getCompanyStrategySelection()
    {
        return $this->CompanyStrategySelection;
    }
    /**
     * Set CompanyStrategySelection value
     * @param \StructType\CompanyStrategySelection $companyStrategySelection
     * @return \StructType\Update
     */
    public function setCompanyStrategySelection(\StructType\CompanyStrategySelection $companyStrategySelection = null)
    {
        $this->CompanyStrategySelection = $companyStrategySelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Update
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
