<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripItemResult_v2 StructType
 * @subpackage Structs
 */
class TripItemResult_v2 extends Trip
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ModificationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The TransferStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransferStatus;
    /**
     * The ExternalSynchStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The CancelStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Author
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The Places
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceIdentifier
     */
    public $Places;
    /**
     * The TachoActivities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTachoActivity
     */
    public $TachoActivities;
    /**
     * The Registrations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRegistration_v2
     */
    public $Registrations;
    /**
     * Constructor method for TripItemResult_v2
     * @uses TripItemResult_v2::setStartDate()
     * @uses TripItemResult_v2::setEndDate()
     * @uses TripItemResult_v2::setModificationDate()
     * @uses TripItemResult_v2::setStatus()
     * @uses TripItemResult_v2::setTransferStatus()
     * @uses TripItemResult_v2::setExternalSynchStatus()
     * @uses TripItemResult_v2::setCancelStatus()
     * @uses TripItemResult_v2::setDriver()
     * @uses TripItemResult_v2::setVehicle()
     * @uses TripItemResult_v2::setAuthor()
     * @uses TripItemResult_v2::setPlaces()
     * @uses TripItemResult_v2::setTachoActivities()
     * @uses TripItemResult_v2::setRegistrations()
     * @param string $startDate
     * @param string $endDate
     * @param string $modificationDate
     * @param string $status
     * @param string $transferStatus
     * @param string $externalSynchStatus
     * @param string $cancelStatus
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param string $author
     * @param \ArrayType\ArrayOfPlaceIdentifier $places
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @param \ArrayType\ArrayOfRegistration_v2 $registrations
     */
    public function __construct($startDate = null, $endDate = null, $modificationDate = null, $status = null, $transferStatus = null, $externalSynchStatus = null, $cancelStatus = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicleResult $vehicle = null, $author = null, \ArrayType\ArrayOfPlaceIdentifier $places = null, \ArrayType\ArrayOfTachoActivity $tachoActivities = null, \ArrayType\ArrayOfRegistration_v2 $registrations = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setModificationDate($modificationDate)
            ->setStatus($status)
            ->setTransferStatus($transferStatus)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setCancelStatus($cancelStatus)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setAuthor($author)
            ->setPlaces($places)
            ->setTachoActivities($tachoActivities)
            ->setRegistrations($registrations);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\TripItemResult_v2
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\TripItemResult_v2
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\TripItemResult_v2
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumPlanningStatus::valueIsValid()
     * @uses \EnumType\EnumPlanningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\TripItemResult_v2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\EnumPlanningStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransferStatus value
     * @return string
     */
    public function getTransferStatus()
    {
        return $this->TransferStatus;
    }
    /**
     * Set TransferStatus value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferStatus
     * @return \StructType\TripItemResult_v2
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transferStatus, implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->TransferStatus = $transferStatus;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\TripItemResult_v2
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $externalSynchStatus, implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\TripItemResult_v2
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cancelStatus, implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\TripItemResult_v2
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\TripItemResult_v2
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\TripItemResult_v2
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceIdentifier|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceIdentifier $places
     * @return \StructType\TripItemResult_v2
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceIdentifier $places = null)
    {
        $this->Places = $places;
        return $this;
    }
    /**
     * Get TachoActivities value
     * @return \ArrayType\ArrayOfTachoActivity|null
     */
    public function getTachoActivities()
    {
        return $this->TachoActivities;
    }
    /**
     * Set TachoActivities value
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @return \StructType\TripItemResult_v2
     */
    public function setTachoActivities(\ArrayType\ArrayOfTachoActivity $tachoActivities = null)
    {
        $this->TachoActivities = $tachoActivities;
        return $this;
    }
    /**
     * Get Registrations value
     * @return \ArrayType\ArrayOfRegistration_v2|null
     */
    public function getRegistrations()
    {
        return $this->Registrations;
    }
    /**
     * Set Registrations value
     * @param \ArrayType\ArrayOfRegistration_v2 $registrations
     * @return \StructType\TripItemResult_v2
     */
    public function setRegistrations(\ArrayType\ArrayOfRegistration_v2 $registrations = null)
    {
        $this->Registrations = $registrations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripItemResult_v2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
