<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripIdentifier_V2 StructType
 * @subpackage Structs
 */
class TripIdentifier_V2 extends AbstractStructBase
{
    /**
     * The TransicsId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsId;
    /**
     * The TripId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripId;
    /**
     * Constructor method for TripIdentifier_V2
     * @uses TripIdentifier_V2::setTransicsId()
     * @uses TripIdentifier_V2::setTripId()
     * @param int $transicsId
     * @param string $tripId
     */
    public function __construct($transicsId = null, $tripId = null)
    {
        $this
            ->setTransicsId($transicsId)
            ->setTripId($tripId);
    }
    /**
     * Get TransicsId value
     * @return int
     */
    public function getTransicsId()
    {
        return $this->TransicsId;
    }
    /**
     * Set TransicsId value
     * @param int $transicsId
     * @return \StructType\TripIdentifier_V2
     */
    public function setTransicsId($transicsId = null)
    {
        // validation for constraint: int
        if (!is_null($transicsId) && !is_numeric($transicsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsId)), __LINE__);
        }
        $this->TransicsId = $transicsId;
        return $this;
    }
    /**
     * Get TripId value
     * @return string|null
     */
    public function getTripId()
    {
        return $this->TripId;
    }
    /**
     * Set TripId value
     * @param string $tripId
     * @return \StructType\TripIdentifier_V2
     */
    public function setTripId($tripId = null)
    {
        // validation for constraint: string
        if (!is_null($tripId) && !is_string($tripId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripId)), __LINE__);
        }
        $this->TripId = $tripId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripIdentifier_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
