<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripIdentifier StructType
 * @subpackage Structs
 */
class TripIdentifier extends AbstractStructBase
{
    /**
     * The TransicsTripID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsTripID;
    /**
     * The TripID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripID;
    /**
     * Constructor method for TripIdentifier
     * @uses TripIdentifier::setTransicsTripID()
     * @uses TripIdentifier::setTripID()
     * @param int $transicsTripID
     * @param string $tripID
     */
    public function __construct($transicsTripID = null, $tripID = null)
    {
        $this
            ->setTransicsTripID($transicsTripID)
            ->setTripID($tripID);
    }
    /**
     * Get TransicsTripID value
     * @return int
     */
    public function getTransicsTripID()
    {
        return $this->TransicsTripID;
    }
    /**
     * Set TransicsTripID value
     * @param int $transicsTripID
     * @return \StructType\TripIdentifier
     */
    public function setTransicsTripID($transicsTripID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsTripID) && !is_numeric($transicsTripID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsTripID)), __LINE__);
        }
        $this->TransicsTripID = $transicsTripID;
        return $this;
    }
    /**
     * Get TripID value
     * @return string|null
     */
    public function getTripID()
    {
        return $this->TripID;
    }
    /**
     * Set TripID value
     * @param string $tripID
     * @return \StructType\TripIdentifier
     */
    public function setTripID($tripID = null)
    {
        // validation for constraint: string
        if (!is_null($tripID) && !is_string($tripID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripID)), __LINE__);
        }
        $this->TripID = $tripID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TripIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
