<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailerSubGroupItem StructType
 * @subpackage Structs
 */
class TrailerSubGroupItem extends AbstractStructBase
{
    /**
     * The SubGroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The SubGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupName;
    /**
     * The TrailerList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTrackedVehicle
     */
    public $TrailerList;
    /**
     * Constructor method for TrailerSubGroupItem
     * @uses TrailerSubGroupItem::setSubGroupCode()
     * @uses TrailerSubGroupItem::setSubGroupName()
     * @uses TrailerSubGroupItem::setTrailerList()
     * @param string $subGroupCode
     * @param string $subGroupName
     * @param \ArrayType\ArrayOfTrackedVehicle $trailerList
     */
    public function __construct($subGroupCode = null, $subGroupName = null, \ArrayType\ArrayOfTrackedVehicle $trailerList = null)
    {
        $this
            ->setSubGroupCode($subGroupCode)
            ->setSubGroupName($subGroupName)
            ->setTrailerList($trailerList);
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\TrailerSubGroupItem
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get SubGroupName value
     * @return string|null
     */
    public function getSubGroupName()
    {
        return $this->SubGroupName;
    }
    /**
     * Set SubGroupName value
     * @param string $subGroupName
     * @return \StructType\TrailerSubGroupItem
     */
    public function setSubGroupName($subGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupName) && !is_string($subGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subGroupName)), __LINE__);
        }
        $this->SubGroupName = $subGroupName;
        return $this;
    }
    /**
     * Get TrailerList value
     * @return \ArrayType\ArrayOfTrackedVehicle|null
     */
    public function getTrailerList()
    {
        return $this->TrailerList;
    }
    /**
     * Set TrailerList value
     * @param \ArrayType\ArrayOfTrackedVehicle $trailerList
     * @return \StructType\TrailerSubGroupItem
     */
    public function setTrailerList(\ArrayType\ArrayOfTrackedVehicle $trailerList = null)
    {
        $this->TrailerList = $trailerList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrailerSubGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
