<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailerResult StructType
 * @subpackage Structs
 */
class TrailerResult extends Trailer
{
    /**
     * The TrailerTransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TrailerTransicsID;
    /**
     * The Modified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The CurrentKms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentKms;
    /**
     * The FuelLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevel;
    /**
     * The FuelLevelIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevelIndex;
    /**
     * The RefrigeratorIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RefrigeratorIndex;
    /**
     * The ActivityCompleted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ActivityCompleted;
    /**
     * The Site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierResult
     */
    public $Site;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The ObcInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerObcInfo
     */
    public $ObcInfo;
    /**
     * The ETAInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerETAInfo
     */
    public $ETAInfo;
    /**
     * The TemperatureInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerTemperatureInfo
     */
    public $TemperatureInfo;
    /**
     * The InfoFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerInfoFields
     */
    public $InfoFields;
    /**
     * The UpdateDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerUpdateDates
     */
    public $UpdateDates;
    /**
     * The VehicleCostInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerCostInfo
     */
    public $VehicleCostInfo;
    /**
     * The NextStopInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopResult
     */
    public $NextStopInfo;
    /**
     * The FormattedTrailerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedTrailerName;
    /**
     * Constructor method for TrailerResult
     * @uses TrailerResult::setTrailerTransicsID()
     * @uses TrailerResult::setModified()
     * @uses TrailerResult::setCurrentKms()
     * @uses TrailerResult::setFuelLevel()
     * @uses TrailerResult::setFuelLevelIndex()
     * @uses TrailerResult::setRefrigeratorIndex()
     * @uses TrailerResult::setActivityCompleted()
     * @uses TrailerResult::setSite()
     * @uses TrailerResult::setPosition()
     * @uses TrailerResult::setActivity()
     * @uses TrailerResult::setDriver()
     * @uses TrailerResult::setCoDriver()
     * @uses TrailerResult::setVehicle()
     * @uses TrailerResult::setObcInfo()
     * @uses TrailerResult::setETAInfo()
     * @uses TrailerResult::setTemperatureInfo()
     * @uses TrailerResult::setInfoFields()
     * @uses TrailerResult::setUpdateDates()
     * @uses TrailerResult::setVehicleCostInfo()
     * @uses TrailerResult::setNextStopInfo()
     * @uses TrailerResult::setFormattedTrailerName()
     * @param int $trailerTransicsID
     * @param string $modified
     * @param int $currentKms
     * @param int $fuelLevel
     * @param int $fuelLevelIndex
     * @param int $refrigeratorIndex
     * @param bool $activityCompleted
     * @param \StructType\IdentifierResult $site
     * @param \StructType\PositionResult $position
     * @param \StructType\Activity $activity
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\TrailerObcInfo $obcInfo
     * @param \StructType\TrailerETAInfo $eTAInfo
     * @param \StructType\TrailerTemperatureInfo $temperatureInfo
     * @param \StructType\TrailerInfoFields $infoFields
     * @param \StructType\TrailerUpdateDates $updateDates
     * @param \StructType\TrailerCostInfo $vehicleCostInfo
     * @param \StructType\NextStopResult $nextStopInfo
     * @param string $formattedTrailerName
     */
    public function __construct($trailerTransicsID = null, $modified = null, $currentKms = null, $fuelLevel = null, $fuelLevelIndex = null, $refrigeratorIndex = null, $activityCompleted = null, \StructType\IdentifierResult $site = null, \StructType\PositionResult $position = null, \StructType\Activity $activity = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $coDriver = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\TrailerObcInfo $obcInfo = null, \StructType\TrailerETAInfo $eTAInfo = null, \StructType\TrailerTemperatureInfo $temperatureInfo = null, \StructType\TrailerInfoFields $infoFields = null, \StructType\TrailerUpdateDates $updateDates = null, \StructType\TrailerCostInfo $vehicleCostInfo = null, \StructType\NextStopResult $nextStopInfo = null, $formattedTrailerName = null)
    {
        $this
            ->setTrailerTransicsID($trailerTransicsID)
            ->setModified($modified)
            ->setCurrentKms($currentKms)
            ->setFuelLevel($fuelLevel)
            ->setFuelLevelIndex($fuelLevelIndex)
            ->setRefrigeratorIndex($refrigeratorIndex)
            ->setActivityCompleted($activityCompleted)
            ->setSite($site)
            ->setPosition($position)
            ->setActivity($activity)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setVehicle($vehicle)
            ->setObcInfo($obcInfo)
            ->setETAInfo($eTAInfo)
            ->setTemperatureInfo($temperatureInfo)
            ->setInfoFields($infoFields)
            ->setUpdateDates($updateDates)
            ->setVehicleCostInfo($vehicleCostInfo)
            ->setNextStopInfo($nextStopInfo)
            ->setFormattedTrailerName($formattedTrailerName);
    }
    /**
     * Get TrailerTransicsID value
     * @return int
     */
    public function getTrailerTransicsID()
    {
        return $this->TrailerTransicsID;
    }
    /**
     * Set TrailerTransicsID value
     * @param int $trailerTransicsID
     * @return \StructType\TrailerResult
     */
    public function setTrailerTransicsID($trailerTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($trailerTransicsID) && !is_numeric($trailerTransicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($trailerTransicsID)), __LINE__);
        }
        $this->TrailerTransicsID = $trailerTransicsID;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\TrailerResult
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get CurrentKms value
     * @return int
     */
    public function getCurrentKms()
    {
        return $this->CurrentKms;
    }
    /**
     * Set CurrentKms value
     * @param int $currentKms
     * @return \StructType\TrailerResult
     */
    public function setCurrentKms($currentKms = null)
    {
        // validation for constraint: int
        if (!is_null($currentKms) && !is_numeric($currentKms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentKms)), __LINE__);
        }
        $this->CurrentKms = $currentKms;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\TrailerResult
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !is_numeric($fuelLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get FuelLevelIndex value
     * @return int
     */
    public function getFuelLevelIndex()
    {
        return $this->FuelLevelIndex;
    }
    /**
     * Set FuelLevelIndex value
     * @param int $fuelLevelIndex
     * @return \StructType\TrailerResult
     */
    public function setFuelLevelIndex($fuelLevelIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevelIndex) && !is_numeric($fuelLevelIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevelIndex)), __LINE__);
        }
        $this->FuelLevelIndex = $fuelLevelIndex;
        return $this;
    }
    /**
     * Get RefrigeratorIndex value
     * @return int
     */
    public function getRefrigeratorIndex()
    {
        return $this->RefrigeratorIndex;
    }
    /**
     * Set RefrigeratorIndex value
     * @param int $refrigeratorIndex
     * @return \StructType\TrailerResult
     */
    public function setRefrigeratorIndex($refrigeratorIndex = null)
    {
        // validation for constraint: int
        if (!is_null($refrigeratorIndex) && !is_numeric($refrigeratorIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($refrigeratorIndex)), __LINE__);
        }
        $this->RefrigeratorIndex = $refrigeratorIndex;
        return $this;
    }
    /**
     * Get ActivityCompleted value
     * @return bool
     */
    public function getActivityCompleted()
    {
        return $this->ActivityCompleted;
    }
    /**
     * Set ActivityCompleted value
     * @param bool $activityCompleted
     * @return \StructType\TrailerResult
     */
    public function setActivityCompleted($activityCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($activityCompleted) && !is_bool($activityCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($activityCompleted)), __LINE__);
        }
        $this->ActivityCompleted = $activityCompleted;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierResult|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierResult $site
     * @return \StructType\TrailerResult
     */
    public function setSite(\StructType\IdentifierResult $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\TrailerResult
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\TrailerResult
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\TrailerResult
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\TrailerResult
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TrailerResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get ObcInfo value
     * @return \StructType\TrailerObcInfo|null
     */
    public function getObcInfo()
    {
        return $this->ObcInfo;
    }
    /**
     * Set ObcInfo value
     * @param \StructType\TrailerObcInfo $obcInfo
     * @return \StructType\TrailerResult
     */
    public function setObcInfo(\StructType\TrailerObcInfo $obcInfo = null)
    {
        $this->ObcInfo = $obcInfo;
        return $this;
    }
    /**
     * Get ETAInfo value
     * @return \StructType\TrailerETAInfo|null
     */
    public function getETAInfo()
    {
        return $this->ETAInfo;
    }
    /**
     * Set ETAInfo value
     * @param \StructType\TrailerETAInfo $eTAInfo
     * @return \StructType\TrailerResult
     */
    public function setETAInfo(\StructType\TrailerETAInfo $eTAInfo = null)
    {
        $this->ETAInfo = $eTAInfo;
        return $this;
    }
    /**
     * Get TemperatureInfo value
     * @return \StructType\TrailerTemperatureInfo|null
     */
    public function getTemperatureInfo()
    {
        return $this->TemperatureInfo;
    }
    /**
     * Set TemperatureInfo value
     * @param \StructType\TrailerTemperatureInfo $temperatureInfo
     * @return \StructType\TrailerResult
     */
    public function setTemperatureInfo(\StructType\TrailerTemperatureInfo $temperatureInfo = null)
    {
        $this->TemperatureInfo = $temperatureInfo;
        return $this;
    }
    /**
     * Get InfoFields value
     * @return \StructType\TrailerInfoFields|null
     */
    public function getInfoFields()
    {
        return $this->InfoFields;
    }
    /**
     * Set InfoFields value
     * @param \StructType\TrailerInfoFields $infoFields
     * @return \StructType\TrailerResult
     */
    public function setInfoFields(\StructType\TrailerInfoFields $infoFields = null)
    {
        $this->InfoFields = $infoFields;
        return $this;
    }
    /**
     * Get UpdateDates value
     * @return \StructType\TrailerUpdateDates|null
     */
    public function getUpdateDates()
    {
        return $this->UpdateDates;
    }
    /**
     * Set UpdateDates value
     * @param \StructType\TrailerUpdateDates $updateDates
     * @return \StructType\TrailerResult
     */
    public function setUpdateDates(\StructType\TrailerUpdateDates $updateDates = null)
    {
        $this->UpdateDates = $updateDates;
        return $this;
    }
    /**
     * Get VehicleCostInfo value
     * @return \StructType\TrailerCostInfo|null
     */
    public function getVehicleCostInfo()
    {
        return $this->VehicleCostInfo;
    }
    /**
     * Set VehicleCostInfo value
     * @param \StructType\TrailerCostInfo $vehicleCostInfo
     * @return \StructType\TrailerResult
     */
    public function setVehicleCostInfo(\StructType\TrailerCostInfo $vehicleCostInfo = null)
    {
        $this->VehicleCostInfo = $vehicleCostInfo;
        return $this;
    }
    /**
     * Get NextStopInfo value
     * @return \StructType\NextStopResult|null
     */
    public function getNextStopInfo()
    {
        return $this->NextStopInfo;
    }
    /**
     * Set NextStopInfo value
     * @param \StructType\NextStopResult $nextStopInfo
     * @return \StructType\TrailerResult
     */
    public function setNextStopInfo(\StructType\NextStopResult $nextStopInfo = null)
    {
        $this->NextStopInfo = $nextStopInfo;
        return $this;
    }
    /**
     * Get FormattedTrailerName value
     * @return string|null
     */
    public function getFormattedTrailerName()
    {
        return $this->FormattedTrailerName;
    }
    /**
     * Set FormattedTrailerName value
     * @param string $formattedTrailerName
     * @return \StructType\TrailerResult
     */
    public function setFormattedTrailerName($formattedTrailerName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedTrailerName) && !is_string($formattedTrailerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formattedTrailerName)), __LINE__);
        }
        $this->FormattedTrailerName = $formattedTrailerName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrailerResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
