<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Trailer StructType
 * @subpackage Structs
 */
abstract class Trailer extends AbstractStructBase
{
    /**
     * The Inactive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Inactive;
    /**
     * The CanBusConnection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CanBusConnection;
    /**
     * The TrailerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrailerID;
    /**
     * The LastVehicleCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastVehicleCode;
    /**
     * The TrailerExternalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrailerExternalCode;
    /**
     * The LicensePlate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The ShortName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortName;
    /**
     * The Picture
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Picture;
    /**
     * The PictureSerialized
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PictureSerialized;
    /**
     * The EngineInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerEngineInfo
     */
    public $EngineInfo;
    /**
     * The TechnicalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerTechnicalInfo
     */
    public $TechnicalInfo;
    /**
     * The LoadInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerLoadInfo
     */
    public $LoadInfo;
    /**
     * The ComfortInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerComfortInfo
     */
    public $ComfortInfo;
    /**
     * Constructor method for Trailer
     * @uses Trailer::setInactive()
     * @uses Trailer::setCanBusConnection()
     * @uses Trailer::setTrailerID()
     * @uses Trailer::setLastVehicleCode()
     * @uses Trailer::setTrailerExternalCode()
     * @uses Trailer::setLicensePlate()
     * @uses Trailer::setShortName()
     * @uses Trailer::setPicture()
     * @uses Trailer::setPictureSerialized()
     * @uses Trailer::setEngineInfo()
     * @uses Trailer::setTechnicalInfo()
     * @uses Trailer::setLoadInfo()
     * @uses Trailer::setComfortInfo()
     * @param bool $inactive
     * @param bool $canBusConnection
     * @param string $trailerID
     * @param string $lastVehicleCode
     * @param string $trailerExternalCode
     * @param string $licensePlate
     * @param string $shortName
     * @param string $picture
     * @param string $pictureSerialized
     * @param \StructType\TrailerEngineInfo $engineInfo
     * @param \StructType\TrailerTechnicalInfo $technicalInfo
     * @param \StructType\TrailerLoadInfo $loadInfo
     * @param \StructType\TrailerComfortInfo $comfortInfo
     */
    public function __construct($inactive = null, $canBusConnection = null, $trailerID = null, $lastVehicleCode = null, $trailerExternalCode = null, $licensePlate = null, $shortName = null, $picture = null, $pictureSerialized = null, \StructType\TrailerEngineInfo $engineInfo = null, \StructType\TrailerTechnicalInfo $technicalInfo = null, \StructType\TrailerLoadInfo $loadInfo = null, \StructType\TrailerComfortInfo $comfortInfo = null)
    {
        $this
            ->setInactive($inactive)
            ->setCanBusConnection($canBusConnection)
            ->setTrailerID($trailerID)
            ->setLastVehicleCode($lastVehicleCode)
            ->setTrailerExternalCode($trailerExternalCode)
            ->setLicensePlate($licensePlate)
            ->setShortName($shortName)
            ->setPicture($picture)
            ->setPictureSerialized($pictureSerialized)
            ->setEngineInfo($engineInfo)
            ->setTechnicalInfo($technicalInfo)
            ->setLoadInfo($loadInfo)
            ->setComfortInfo($comfortInfo);
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Trailer
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get CanBusConnection value
     * @return bool
     */
    public function getCanBusConnection()
    {
        return $this->CanBusConnection;
    }
    /**
     * Set CanBusConnection value
     * @param bool $canBusConnection
     * @return \StructType\Trailer
     */
    public function setCanBusConnection($canBusConnection = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBusConnection) && !is_bool($canBusConnection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canBusConnection)), __LINE__);
        }
        $this->CanBusConnection = $canBusConnection;
        return $this;
    }
    /**
     * Get TrailerID value
     * @return string|null
     */
    public function getTrailerID()
    {
        return $this->TrailerID;
    }
    /**
     * Set TrailerID value
     * @param string $trailerID
     * @return \StructType\Trailer
     */
    public function setTrailerID($trailerID = null)
    {
        // validation for constraint: string
        if (!is_null($trailerID) && !is_string($trailerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailerID)), __LINE__);
        }
        $this->TrailerID = $trailerID;
        return $this;
    }
    /**
     * Get LastVehicleCode value
     * @return string|null
     */
    public function getLastVehicleCode()
    {
        return $this->LastVehicleCode;
    }
    /**
     * Set LastVehicleCode value
     * @param string $lastVehicleCode
     * @return \StructType\Trailer
     */
    public function setLastVehicleCode($lastVehicleCode = null)
    {
        // validation for constraint: string
        if (!is_null($lastVehicleCode) && !is_string($lastVehicleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastVehicleCode)), __LINE__);
        }
        $this->LastVehicleCode = $lastVehicleCode;
        return $this;
    }
    /**
     * Get TrailerExternalCode value
     * @return string|null
     */
    public function getTrailerExternalCode()
    {
        return $this->TrailerExternalCode;
    }
    /**
     * Set TrailerExternalCode value
     * @param string $trailerExternalCode
     * @return \StructType\Trailer
     */
    public function setTrailerExternalCode($trailerExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($trailerExternalCode) && !is_string($trailerExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailerExternalCode)), __LINE__);
        }
        $this->TrailerExternalCode = $trailerExternalCode;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\Trailer
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get ShortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->ShortName;
    }
    /**
     * Set ShortName value
     * @param string $shortName
     * @return \StructType\Trailer
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortName)), __LINE__);
        }
        $this->ShortName = $shortName;
        return $this;
    }
    /**
     * Get Picture value
     * @return string|null
     */
    public function getPicture()
    {
        return $this->Picture;
    }
    /**
     * Set Picture value
     * @param string $picture
     * @return \StructType\Trailer
     */
    public function setPicture($picture = null)
    {
        // validation for constraint: string
        if (!is_null($picture) && !is_string($picture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($picture)), __LINE__);
        }
        $this->Picture = $picture;
        return $this;
    }
    /**
     * Get PictureSerialized value
     * @return string|null
     */
    public function getPictureSerialized()
    {
        return $this->PictureSerialized;
    }
    /**
     * Set PictureSerialized value
     * @param string $pictureSerialized
     * @return \StructType\Trailer
     */
    public function setPictureSerialized($pictureSerialized = null)
    {
        // validation for constraint: string
        if (!is_null($pictureSerialized) && !is_string($pictureSerialized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pictureSerialized)), __LINE__);
        }
        $this->PictureSerialized = $pictureSerialized;
        return $this;
    }
    /**
     * Get EngineInfo value
     * @return \StructType\TrailerEngineInfo|null
     */
    public function getEngineInfo()
    {
        return $this->EngineInfo;
    }
    /**
     * Set EngineInfo value
     * @param \StructType\TrailerEngineInfo $engineInfo
     * @return \StructType\Trailer
     */
    public function setEngineInfo(\StructType\TrailerEngineInfo $engineInfo = null)
    {
        $this->EngineInfo = $engineInfo;
        return $this;
    }
    /**
     * Get TechnicalInfo value
     * @return \StructType\TrailerTechnicalInfo|null
     */
    public function getTechnicalInfo()
    {
        return $this->TechnicalInfo;
    }
    /**
     * Set TechnicalInfo value
     * @param \StructType\TrailerTechnicalInfo $technicalInfo
     * @return \StructType\Trailer
     */
    public function setTechnicalInfo(\StructType\TrailerTechnicalInfo $technicalInfo = null)
    {
        $this->TechnicalInfo = $technicalInfo;
        return $this;
    }
    /**
     * Get LoadInfo value
     * @return \StructType\TrailerLoadInfo|null
     */
    public function getLoadInfo()
    {
        return $this->LoadInfo;
    }
    /**
     * Set LoadInfo value
     * @param \StructType\TrailerLoadInfo $loadInfo
     * @return \StructType\Trailer
     */
    public function setLoadInfo(\StructType\TrailerLoadInfo $loadInfo = null)
    {
        $this->LoadInfo = $loadInfo;
        return $this;
    }
    /**
     * Get ComfortInfo value
     * @return \StructType\TrailerComfortInfo|null
     */
    public function getComfortInfo()
    {
        return $this->ComfortInfo;
    }
    /**
     * Set ComfortInfo value
     * @param \StructType\TrailerComfortInfo $comfortInfo
     * @return \StructType\Trailer
     */
    public function setComfortInfo(\StructType\TrailerComfortInfo $comfortInfo = null)
    {
        $this->ComfortInfo = $comfortInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Trailer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
