<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TracerDistanceReportSelection StructType
 * @subpackage Structs
 */
class TracerDistanceReportSelection extends AbstractStructBase
{
    /**
     * The SummaryLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SummaryLevel;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicleExtra
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicleExtra
     */
    public $Trailers;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * The DateTimeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $DateTimeSelection;
    /**
     * Constructor method for TracerDistanceReportSelection
     * @uses TracerDistanceReportSelection::setSummaryLevel()
     * @uses TracerDistanceReportSelection::setVehicles()
     * @uses TracerDistanceReportSelection::setTrailers()
     * @uses TracerDistanceReportSelection::setDateTimeRangeSelection()
     * @uses TracerDistanceReportSelection::setDateTimeSelection()
     * @param string $summaryLevel
     * @param \ArrayType\ArrayOfIdentifierVehicleExtra $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicleExtra $trailers
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @param \StructType\DateTimeSelection $dateTimeSelection
     */
    public function __construct($summaryLevel = null, \ArrayType\ArrayOfIdentifierVehicleExtra $vehicles = null, \ArrayType\ArrayOfIdentifierVehicleExtra $trailers = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null, \StructType\DateTimeSelection $dateTimeSelection = null)
    {
        $this
            ->setSummaryLevel($summaryLevel)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setDateTimeRangeSelection($dateTimeRangeSelection)
            ->setDateTimeSelection($dateTimeSelection);
    }
    /**
     * Get SummaryLevel value
     * @return string
     */
    public function getSummaryLevel()
    {
        return $this->SummaryLevel;
    }
    /**
     * Set SummaryLevel value
     * @uses \EnumType\SummaryLevel::valueIsValid()
     * @uses \EnumType\SummaryLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $summaryLevel
     * @return \StructType\TracerDistanceReportSelection
     */
    public function setSummaryLevel($summaryLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SummaryLevel::valueIsValid($summaryLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $summaryLevel, implode(', ', \EnumType\SummaryLevel::getValidValues())), __LINE__);
        }
        $this->SummaryLevel = $summaryLevel;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicleExtra|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicleExtra $vehicles
     * @return \StructType\TracerDistanceReportSelection
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicleExtra $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicleExtra|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicleExtra $trailers
     * @return \StructType\TracerDistanceReportSelection
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicleExtra $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\TracerDistanceReportSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Get DateTimeSelection value
     * @return \StructType\DateTimeSelection|null
     */
    public function getDateTimeSelection()
    {
        return $this->DateTimeSelection;
    }
    /**
     * Set DateTimeSelection value
     * @param \StructType\DateTimeSelection $dateTimeSelection
     * @return \StructType\TracerDistanceReportSelection
     */
    public function setDateTimeSelection(\StructType\DateTimeSelection $dateTimeSelection = null)
    {
        $this->DateTimeSelection = $dateTimeSelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TracerDistanceReportSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
