<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextMessageInbox_V4 StructType
 * @subpackage Structs
 */
class TextMessageInbox_V4 extends TextMessage
{
    /**
     * The ReadDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadDate;
    /**
     * The Read
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Read;
    /**
     * The TextMessageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TextMessageID;
    /**
     * The KmVehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmVehicle;
    /**
     * The DeliveredDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeliveredDate;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModifiedDate;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The FuellevelVehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuellevelVehicle;
    /**
     * The InterfaceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $InterfaceInfo;
    /**
     * The Treated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Treated;
    /**
     * The GsmNr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GsmNr;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The OutboxMessageRepliedFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TextMessageOutbox_V4
     */
    public $OutboxMessageRepliedFrom;
    /**
     * The RepliesOnInboxMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTextMessageOutbox_V4
     */
    public $RepliesOnInboxMessage;
    /**
     * Constructor method for TextMessageInbox_V4
     * @uses TextMessageInbox_V4::setReadDate()
     * @uses TextMessageInbox_V4::setRead()
     * @uses TextMessageInbox_V4::setTextMessageID()
     * @uses TextMessageInbox_V4::setKmVehicle()
     * @uses TextMessageInbox_V4::setDeliveredDate()
     * @uses TextMessageInbox_V4::setCreationDate()
     * @uses TextMessageInbox_V4::setModifiedDate()
     * @uses TextMessageInbox_V4::setArrivalDateTime()
     * @uses TextMessageInbox_V4::setFuellevelVehicle()
     * @uses TextMessageInbox_V4::setInterfaceInfo()
     * @uses TextMessageInbox_V4::setTreated()
     * @uses TextMessageInbox_V4::setGsmNr()
     * @uses TextMessageInbox_V4::setActivity()
     * @uses TextMessageInbox_V4::setPosition()
     * @uses TextMessageInbox_V4::setVehicle()
     * @uses TextMessageInbox_V4::setTrailer()
     * @uses TextMessageInbox_V4::setDriver()
     * @uses TextMessageInbox_V4::setOutboxMessageRepliedFrom()
     * @uses TextMessageInbox_V4::setRepliesOnInboxMessage()
     * @param string $readDate
     * @param bool $read
     * @param int $textMessageID
     * @param int $kmVehicle
     * @param string $deliveredDate
     * @param string $creationDate
     * @param string $modifiedDate
     * @param string $arrivalDateTime
     * @param int $fuellevelVehicle
     * @param float $interfaceInfo
     * @param bool $treated
     * @param string $gsmNr
     * @param \StructType\Activity $activity
     * @param \StructType\PositionResult $position
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\TextMessageOutbox_V4 $outboxMessageRepliedFrom
     * @param \ArrayType\ArrayOfTextMessageOutbox_V4 $repliesOnInboxMessage
     */
    public function __construct($readDate = null, $read = null, $textMessageID = null, $kmVehicle = null, $deliveredDate = null, $creationDate = null, $modifiedDate = null, $arrivalDateTime = null, $fuellevelVehicle = null, $interfaceInfo = null, $treated = null, $gsmNr = null, \StructType\Activity $activity = null, \StructType\PositionResult $position = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierVehicleResult_V2 $trailer = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\TextMessageOutbox_V4 $outboxMessageRepliedFrom = null, \ArrayType\ArrayOfTextMessageOutbox_V4 $repliesOnInboxMessage = null)
    {
        $this
            ->setReadDate($readDate)
            ->setRead($read)
            ->setTextMessageID($textMessageID)
            ->setKmVehicle($kmVehicle)
            ->setDeliveredDate($deliveredDate)
            ->setCreationDate($creationDate)
            ->setModifiedDate($modifiedDate)
            ->setArrivalDateTime($arrivalDateTime)
            ->setFuellevelVehicle($fuellevelVehicle)
            ->setInterfaceInfo($interfaceInfo)
            ->setTreated($treated)
            ->setGsmNr($gsmNr)
            ->setActivity($activity)
            ->setPosition($position)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setOutboxMessageRepliedFrom($outboxMessageRepliedFrom)
            ->setRepliesOnInboxMessage($repliesOnInboxMessage);
    }
    /**
     * Get ReadDate value
     * @return string
     */
    public function getReadDate()
    {
        return $this->ReadDate;
    }
    /**
     * Set ReadDate value
     * @param string $readDate
     * @return \StructType\TextMessageInbox_V4
     */
    public function setReadDate($readDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDate) && !is_string($readDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDate)), __LINE__);
        }
        $this->ReadDate = $readDate;
        return $this;
    }
    /**
     * Get Read value
     * @return bool
     */
    public function getRead()
    {
        return $this->Read;
    }
    /**
     * Set Read value
     * @param bool $read
     * @return \StructType\TextMessageInbox_V4
     */
    public function setRead($read = null)
    {
        // validation for constraint: boolean
        if (!is_null($read) && !is_bool($read)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($read)), __LINE__);
        }
        $this->Read = $read;
        return $this;
    }
    /**
     * Get TextMessageID value
     * @return int
     */
    public function getTextMessageID()
    {
        return $this->TextMessageID;
    }
    /**
     * Set TextMessageID value
     * @param int $textMessageID
     * @return \StructType\TextMessageInbox_V4
     */
    public function setTextMessageID($textMessageID = null)
    {
        // validation for constraint: int
        if (!is_null($textMessageID) && !is_numeric($textMessageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($textMessageID)), __LINE__);
        }
        $this->TextMessageID = $textMessageID;
        return $this;
    }
    /**
     * Get KmVehicle value
     * @return int
     */
    public function getKmVehicle()
    {
        return $this->KmVehicle;
    }
    /**
     * Set KmVehicle value
     * @param int $kmVehicle
     * @return \StructType\TextMessageInbox_V4
     */
    public function setKmVehicle($kmVehicle = null)
    {
        // validation for constraint: int
        if (!is_null($kmVehicle) && !is_numeric($kmVehicle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmVehicle)), __LINE__);
        }
        $this->KmVehicle = $kmVehicle;
        return $this;
    }
    /**
     * Get DeliveredDate value
     * @return string
     */
    public function getDeliveredDate()
    {
        return $this->DeliveredDate;
    }
    /**
     * Set DeliveredDate value
     * @param string $deliveredDate
     * @return \StructType\TextMessageInbox_V4
     */
    public function setDeliveredDate($deliveredDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredDate) && !is_string($deliveredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveredDate)), __LINE__);
        }
        $this->DeliveredDate = $deliveredDate;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\TextMessageInbox_V4
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\TextMessageInbox_V4
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\TextMessageInbox_V4
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get FuellevelVehicle value
     * @return int
     */
    public function getFuellevelVehicle()
    {
        return $this->FuellevelVehicle;
    }
    /**
     * Set FuellevelVehicle value
     * @param int $fuellevelVehicle
     * @return \StructType\TextMessageInbox_V4
     */
    public function setFuellevelVehicle($fuellevelVehicle = null)
    {
        // validation for constraint: int
        if (!is_null($fuellevelVehicle) && !is_numeric($fuellevelVehicle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuellevelVehicle)), __LINE__);
        }
        $this->FuellevelVehicle = $fuellevelVehicle;
        return $this;
    }
    /**
     * Get InterfaceInfo value
     * @return float
     */
    public function getInterfaceInfo()
    {
        return $this->InterfaceInfo;
    }
    /**
     * Set InterfaceInfo value
     * @param float $interfaceInfo
     * @return \StructType\TextMessageInbox_V4
     */
    public function setInterfaceInfo($interfaceInfo = null)
    {
        $this->InterfaceInfo = $interfaceInfo;
        return $this;
    }
    /**
     * Get Treated value
     * @return bool
     */
    public function getTreated()
    {
        return $this->Treated;
    }
    /**
     * Set Treated value
     * @param bool $treated
     * @return \StructType\TextMessageInbox_V4
     */
    public function setTreated($treated = null)
    {
        // validation for constraint: boolean
        if (!is_null($treated) && !is_bool($treated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($treated)), __LINE__);
        }
        $this->Treated = $treated;
        return $this;
    }
    /**
     * Get GsmNr value
     * @return string|null
     */
    public function getGsmNr()
    {
        return $this->GsmNr;
    }
    /**
     * Set GsmNr value
     * @param string $gsmNr
     * @return \StructType\TextMessageInbox_V4
     */
    public function setGsmNr($gsmNr = null)
    {
        // validation for constraint: string
        if (!is_null($gsmNr) && !is_string($gsmNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gsmNr)), __LINE__);
        }
        $this->GsmNr = $gsmNr;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\TextMessageInbox_V4
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\TextMessageInbox_V4
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TextMessageInbox_V4
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult_V2 $trailer
     * @return \StructType\TextMessageInbox_V4
     */
    public function setTrailer(\StructType\IdentifierVehicleResult_V2 $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\TextMessageInbox_V4
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get OutboxMessageRepliedFrom value
     * @return \StructType\TextMessageOutbox_V4|null
     */
    public function getOutboxMessageRepliedFrom()
    {
        return $this->OutboxMessageRepliedFrom;
    }
    /**
     * Set OutboxMessageRepliedFrom value
     * @param \StructType\TextMessageOutbox_V4 $outboxMessageRepliedFrom
     * @return \StructType\TextMessageInbox_V4
     */
    public function setOutboxMessageRepliedFrom(\StructType\TextMessageOutbox_V4 $outboxMessageRepliedFrom = null)
    {
        $this->OutboxMessageRepliedFrom = $outboxMessageRepliedFrom;
        return $this;
    }
    /**
     * Get RepliesOnInboxMessage value
     * @return \ArrayType\ArrayOfTextMessageOutbox_V4|null
     */
    public function getRepliesOnInboxMessage()
    {
        return $this->RepliesOnInboxMessage;
    }
    /**
     * Set RepliesOnInboxMessage value
     * @param \ArrayType\ArrayOfTextMessageOutbox_V4 $repliesOnInboxMessage
     * @return \StructType\TextMessageInbox_V4
     */
    public function setRepliesOnInboxMessage(\ArrayType\ArrayOfTextMessageOutbox_V4 $repliesOnInboxMessage = null)
    {
        $this->RepliesOnInboxMessage = $repliesOnInboxMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TextMessageInbox_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
