<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextMessageInboxSelection StructType
 * @subpackage Structs
 */
class TextMessageInboxSelection extends AbstractStructBase
{
    /**
     * The Read
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Read;
    /**
     * The DateTimeRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRange;
    /**
     * The SelectionFromToday
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSelection
     */
    public $SelectionFromToday;
    /**
     * The TextMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLong
     */
    public $TextMessages;
    /**
     * Constructor method for TextMessageInboxSelection
     * @uses TextMessageInboxSelection::setRead()
     * @uses TextMessageInboxSelection::setDateTimeRange()
     * @uses TextMessageInboxSelection::setSelectionFromToday()
     * @uses TextMessageInboxSelection::setTextMessages()
     * @param bool $read
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @param \ArrayType\ArrayOfLong $textMessages
     */
    public function __construct($read = null, \StructType\DateTimeRangeSelection $dateTimeRange = null, \StructType\DateTimeSelection $selectionFromToday = null, \ArrayType\ArrayOfLong $textMessages = null)
    {
        $this
            ->setRead($read)
            ->setDateTimeRange($dateTimeRange)
            ->setSelectionFromToday($selectionFromToday)
            ->setTextMessages($textMessages);
    }
    /**
     * Get Read value
     * @return bool
     */
    public function getRead()
    {
        return $this->Read;
    }
    /**
     * Set Read value
     * @param bool $read
     * @return \StructType\TextMessageInboxSelection
     */
    public function setRead($read = null)
    {
        // validation for constraint: boolean
        if (!is_null($read) && !is_bool($read)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($read)), __LINE__);
        }
        $this->Read = $read;
        return $this;
    }
    /**
     * Get DateTimeRange value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRange()
    {
        return $this->DateTimeRange;
    }
    /**
     * Set DateTimeRange value
     * @param \StructType\DateTimeRangeSelection $dateTimeRange
     * @return \StructType\TextMessageInboxSelection
     */
    public function setDateTimeRange(\StructType\DateTimeRangeSelection $dateTimeRange = null)
    {
        $this->DateTimeRange = $dateTimeRange;
        return $this;
    }
    /**
     * Get SelectionFromToday value
     * @return \StructType\DateTimeSelection|null
     */
    public function getSelectionFromToday()
    {
        return $this->SelectionFromToday;
    }
    /**
     * Set SelectionFromToday value
     * @param \StructType\DateTimeSelection $selectionFromToday
     * @return \StructType\TextMessageInboxSelection
     */
    public function setSelectionFromToday(\StructType\DateTimeSelection $selectionFromToday = null)
    {
        $this->SelectionFromToday = $selectionFromToday;
        return $this;
    }
    /**
     * Get TextMessages value
     * @return \ArrayType\ArrayOfLong|null
     */
    public function getTextMessages()
    {
        return $this->TextMessages;
    }
    /**
     * Set TextMessages value
     * @param \ArrayType\ArrayOfLong $textMessages
     * @return \StructType\TextMessageInboxSelection
     */
    public function setTextMessages(\ArrayType\ArrayOfLong $textMessages = null)
    {
        $this->TextMessages = $textMessages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TextMessageInboxSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
