<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextMessage StructType
 * @subpackage Structs
 */
class TextMessage extends AbstractStructBase
{
    /**
     * The ReadConfirmation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ReadConfirmation;
    /**
     * The ReadDeadlineDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadDeadlineDate;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for TextMessage
     * @uses TextMessage::setReadConfirmation()
     * @uses TextMessage::setReadDeadlineDate()
     * @uses TextMessage::setMessage()
     * @param bool $readConfirmation
     * @param string $readDeadlineDate
     * @param string $message
     */
    public function __construct($readConfirmation = null, $readDeadlineDate = null, $message = null)
    {
        $this
            ->setReadConfirmation($readConfirmation)
            ->setReadDeadlineDate($readDeadlineDate)
            ->setMessage($message);
    }
    /**
     * Get ReadConfirmation value
     * @return bool
     */
    public function getReadConfirmation()
    {
        return $this->ReadConfirmation;
    }
    /**
     * Set ReadConfirmation value
     * @param bool $readConfirmation
     * @return \StructType\TextMessage
     */
    public function setReadConfirmation($readConfirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($readConfirmation) && !is_bool($readConfirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($readConfirmation)), __LINE__);
        }
        $this->ReadConfirmation = $readConfirmation;
        return $this;
    }
    /**
     * Get ReadDeadlineDate value
     * @return string
     */
    public function getReadDeadlineDate()
    {
        return $this->ReadDeadlineDate;
    }
    /**
     * Set ReadDeadlineDate value
     * @param string $readDeadlineDate
     * @return \StructType\TextMessage
     */
    public function setReadDeadlineDate($readDeadlineDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDeadlineDate) && !is_string($readDeadlineDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDeadlineDate)), __LINE__);
        }
        $this->ReadDeadlineDate = $readDeadlineDate;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\TextMessage
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TextMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
