<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TachoActivity StructType
 * @subpackage Structs
 */
class TachoActivity extends AbstractStructBase
{
    /**
     * The Export
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Export;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExportDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExportDate;
    /**
     * The Modified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The TachoDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TachoDate;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Source;
    /**
     * The KmsBegin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmsBegin;
    /**
     * The kmsEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $kmsEnd;
    /**
     * The PlaceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceInfo;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The WorkingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * Constructor method for TachoActivity
     * @uses TachoActivity::setExport()
     * @uses TachoActivity::setBeginDate()
     * @uses TachoActivity::setEndDate()
     * @uses TachoActivity::setExportDate()
     * @uses TachoActivity::setModified()
     * @uses TachoActivity::setTachoDate()
     * @uses TachoActivity::setSource()
     * @uses TachoActivity::setKmsBegin()
     * @uses TachoActivity::setKmsEnd()
     * @uses TachoActivity::setPlaceInfo()
     * @uses TachoActivity::setPosition()
     * @uses TachoActivity::setCountryCode()
     * @uses TachoActivity::setWorkingCode()
     * @param bool $export
     * @param string $beginDate
     * @param string $endDate
     * @param string $exportDate
     * @param string $modified
     * @param string $tachoDate
     * @param string $source
     * @param int $kmsBegin
     * @param int $kmsEnd
     * @param string $placeInfo
     * @param \StructType\Position $position
     * @param string $countryCode
     * @param \StructType\CodeInfo $workingCode
     */
    public function __construct($export = null, $beginDate = null, $endDate = null, $exportDate = null, $modified = null, $tachoDate = null, $source = null, $kmsBegin = null, $kmsEnd = null, $placeInfo = null, \StructType\Position $position = null, $countryCode = null, \StructType\CodeInfo $workingCode = null)
    {
        $this
            ->setExport($export)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setExportDate($exportDate)
            ->setModified($modified)
            ->setTachoDate($tachoDate)
            ->setSource($source)
            ->setKmsBegin($kmsBegin)
            ->setKmsEnd($kmsEnd)
            ->setPlaceInfo($placeInfo)
            ->setPosition($position)
            ->setCountryCode($countryCode)
            ->setWorkingCode($workingCode);
    }
    /**
     * Get Export value
     * @return bool
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param bool $export
     * @return \StructType\TachoActivity
     */
    public function setExport($export = null)
    {
        // validation for constraint: boolean
        if (!is_null($export) && !is_bool($export)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\TachoActivity
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\TachoActivity
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ExportDate value
     * @return string
     */
    public function getExportDate()
    {
        return $this->ExportDate;
    }
    /**
     * Set ExportDate value
     * @param string $exportDate
     * @return \StructType\TachoActivity
     */
    public function setExportDate($exportDate = null)
    {
        // validation for constraint: string
        if (!is_null($exportDate) && !is_string($exportDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exportDate)), __LINE__);
        }
        $this->ExportDate = $exportDate;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\TachoActivity
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get TachoDate value
     * @return string
     */
    public function getTachoDate()
    {
        return $this->TachoDate;
    }
    /**
     * Set TachoDate value
     * @param string $tachoDate
     * @return \StructType\TachoActivity
     */
    public function setTachoDate($tachoDate = null)
    {
        // validation for constraint: string
        if (!is_null($tachoDate) && !is_string($tachoDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tachoDate)), __LINE__);
        }
        $this->TachoDate = $tachoDate;
        return $this;
    }
    /**
     * Get Source value
     * @return string
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @uses \EnumType\EnumRegistrationSource::valueIsValid()
     * @uses \EnumType\EnumRegistrationSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\TachoActivity
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumRegistrationSource::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $source, implode(', ', \EnumType\EnumRegistrationSource::getValidValues())), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get KmsBegin value
     * @return int
     */
    public function getKmsBegin()
    {
        return $this->KmsBegin;
    }
    /**
     * Set KmsBegin value
     * @param int $kmsBegin
     * @return \StructType\TachoActivity
     */
    public function setKmsBegin($kmsBegin = null)
    {
        // validation for constraint: int
        if (!is_null($kmsBegin) && !is_numeric($kmsBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmsBegin)), __LINE__);
        }
        $this->KmsBegin = $kmsBegin;
        return $this;
    }
    /**
     * Get kmsEnd value
     * @return int
     */
    public function getKmsEnd()
    {
        return $this->kmsEnd;
    }
    /**
     * Set kmsEnd value
     * @param int $kmsEnd
     * @return \StructType\TachoActivity
     */
    public function setKmsEnd($kmsEnd = null)
    {
        // validation for constraint: int
        if (!is_null($kmsEnd) && !is_numeric($kmsEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmsEnd)), __LINE__);
        }
        $this->kmsEnd = $kmsEnd;
        return $this;
    }
    /**
     * Get PlaceInfo value
     * @return string|null
     */
    public function getPlaceInfo()
    {
        return $this->PlaceInfo;
    }
    /**
     * Set PlaceInfo value
     * @param string $placeInfo
     * @return \StructType\TachoActivity
     */
    public function setPlaceInfo($placeInfo = null)
    {
        // validation for constraint: string
        if (!is_null($placeInfo) && !is_string($placeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeInfo)), __LINE__);
        }
        $this->PlaceInfo = $placeInfo;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\TachoActivity
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\TachoActivity
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\TachoActivity
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TachoActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
