<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SummarizedTachoDataSelection StructType
 * @subpackage Structs
 */
class SummarizedTachoDataSelection extends AbstractStructBase
{
    /**
     * The DataSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataSource;
    /**
     * The SummaryLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SummaryLevel;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * Constructor method for SummarizedTachoDataSelection
     * @uses SummarizedTachoDataSelection::setDataSource()
     * @uses SummarizedTachoDataSelection::setSummaryLevel()
     * @uses SummarizedTachoDataSelection::setDriver()
     * @uses SummarizedTachoDataSelection::setDateTimeRangeSelection()
     * @param string $dataSource
     * @param string $summaryLevel
     * @param \StructType\Identifier $driver
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     */
    public function __construct($dataSource = null, $summaryLevel = null, \StructType\Identifier $driver = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this
            ->setDataSource($dataSource)
            ->setSummaryLevel($summaryLevel)
            ->setDriver($driver)
            ->setDateTimeRangeSelection($dateTimeRangeSelection);
    }
    /**
     * Get DataSource value
     * @return string
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @uses \EnumType\EnumTachoDataSource::valueIsValid()
     * @uses \EnumType\EnumTachoDataSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataSource
     * @return \StructType\SummarizedTachoDataSelection
     */
    public function setDataSource($dataSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTachoDataSource::valueIsValid($dataSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataSource, implode(', ', \EnumType\EnumTachoDataSource::getValidValues())), __LINE__);
        }
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get SummaryLevel value
     * @return string
     */
    public function getSummaryLevel()
    {
        return $this->SummaryLevel;
    }
    /**
     * Set SummaryLevel value
     * @uses \EnumType\EnumSummaryLevel::valueIsValid()
     * @uses \EnumType\EnumSummaryLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $summaryLevel
     * @return \StructType\SummarizedTachoDataSelection
     */
    public function setSummaryLevel($summaryLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSummaryLevel::valueIsValid($summaryLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $summaryLevel, implode(', ', \EnumType\EnumSummaryLevel::getValidValues())), __LINE__);
        }
        $this->SummaryLevel = $summaryLevel;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\SummarizedTachoDataSelection
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\SummarizedTachoDataSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SummarizedTachoDataSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
